/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.gui.RecipesGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;

public class GuiProperties {
    @Nonnull
    private final Class guiClass;
    private final int guiLeft;
    private final int guiXSize;
    private final int screenWidth;
    private final int screenHeight;

    @Nullable
    public static GuiProperties create(@Nonnull GuiScreen guiScreen) {
        int guiXSize;
        int guiLeft;
        if (guiScreen instanceof RecipesGui) {
            RecipesGui recipesGui = (RecipesGui)guiScreen;
            guiLeft = recipesGui.getGuiLeft();
            guiXSize = recipesGui.getXSize();
        } else if (guiScreen instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)guiScreen;
            Container inventorySlots = guiContainer.field_147002_h;
            if (inventorySlots == null) {
                return null;
            }
            List inventory = inventorySlots.func_75138_a();
            if (inventory == null || inventory.isEmpty()) {
                return null;
            }
            guiLeft = guiContainer.field_147003_i;
            guiXSize = guiContainer.field_146999_f;
        } else {
            return null;
        }
        return new GuiProperties(guiScreen.getClass(), guiLeft, guiXSize, guiScreen.field_146294_l, guiScreen.field_146295_m);
    }

    private GuiProperties(@Nonnull Class guiClass, int guiLeft, int guiXSize, int screenWidth, int screenHeight) {
        this.guiClass = guiClass;
        this.guiLeft = guiLeft;
        this.guiXSize = guiXSize;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    @Nonnull
    public Class getGuiClass() {
        return this.guiClass;
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiXSize() {
        return this.guiXSize;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GuiProperties)) {
            return false;
        }
        GuiProperties other = (GuiProperties)obj;
        return this.guiClass == other.getGuiClass() && this.guiLeft == other.getGuiLeft() && this.guiXSize == other.getGuiXSize() && this.screenWidth == other.getScreenWidth() && this.screenHeight == other.getScreenHeight();
    }

    public int hashCode() {
        int result = this.guiClass.hashCode();
        result = 31 * result + this.guiLeft;
        result = 31 * result + this.guiXSize;
        result = 31 * result + this.screenWidth;
        result = 31 * result + this.screenHeight;
        return result;
    }
}

