/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.ItemRegistry;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Java6Helper;
import mezz.jei.util.Log;
import mezz.jei.util.ModList;
import mezz.jei.util.StackHelper;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.tileentity.TileEntityFurnace;

public class ItemRegistryFactory {
    @Nonnull
    private final Set<String> itemNameSet = new HashSet<String>();
    @Nonnull
    private final List<ItemStack> itemList = new ArrayList<ItemStack>();
    @Nonnull
    private final List<ItemStack> fuels = new ArrayList<ItemStack>();
    @Nonnull
    private final List<ItemStack> potionIngredients = new ArrayList<ItemStack>();
    @Nonnull
    private final Set<String> itemWildcardNameSet = new HashSet<String>();
    @Nonnull
    private final List<String> itemAddedOrder = new ArrayList<String>();

    public ItemRegistry createItemRegistry() {
        final ModList modList = new ModList();
        for (CreativeTabs creativeTab : CreativeTabs.field_78032_a) {
            ArrayList creativeTabItemStacks = new ArrayList();
            try {
                creativeTab.func_78018_a(creativeTabItemStacks);
            }
            catch (RuntimeException e) {
                Log.error("Creative tab crashed while getting items. Some items from this tab will be missing from the item list. {}", creativeTab, e);
            }
            catch (LinkageError e) {
                Log.error("Creative tab crashed while getting items. Some items from this tab will be missing from the item list. {}", creativeTab, e);
            }
            for (ItemStack itemStack : creativeTabItemStacks) {
                if (itemStack == null) {
                    Log.error("Found a null itemStack in creative tab: {}", creativeTab);
                    continue;
                }
                if (itemStack.func_77973_b() == null) {
                    Log.error("Found a null item in an itemStack from creative tab: {}", creativeTab);
                    continue;
                }
                this.addItemStack(itemStack);
            }
        }
        for (Block block : Block.field_149771_c) {
            this.addBlockAndSubBlocks(block);
        }
        for (Item item : Item.field_150901_e) {
            this.addItemAndSubItems(item);
        }
        final StackHelper stackHelper = Internal.getStackHelper();
        Collections.sort(this.itemList, new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack stack1, ItemStack stack2) {
                String stack2ModName;
                String stack1ModName = modList.getModNameForItem(stack1.func_77973_b());
                if (stack1ModName.equals(stack2ModName = modList.getModNameForItem(stack2.func_77973_b()))) {
                    String itemUid1 = stackHelper.getUniqueIdentifierForStack(stack1, StackHelper.UidMode.WILDCARD);
                    String itemUid2 = stackHelper.getUniqueIdentifierForStack(stack2, StackHelper.UidMode.WILDCARD);
                    int itemOrderIndex1 = ItemRegistryFactory.this.itemAddedOrder.indexOf(itemUid1);
                    int itemOrderIndex2 = ItemRegistryFactory.this.itemAddedOrder.indexOf(itemUid2);
                    return Java6Helper.compare(itemOrderIndex1, itemOrderIndex2);
                }
                if (stack1ModName.equals("Minecraft")) {
                    return -1;
                }
                if (stack2ModName.equals("Minecraft")) {
                    return 1;
                }
                return stack1ModName.compareTo(stack2ModName);
            }
        });
        ImmutableListMultimap.Builder itemsByModIdBuilder = ImmutableListMultimap.builder();
        for (ItemStack itemStack : this.itemList) {
            Item item = itemStack.func_77973_b();
            if (item == null) continue;
            String modId = stackHelper.getModId(itemStack).toLowerCase(Locale.ENGLISH);
            itemsByModIdBuilder.put((Object)modId, (Object)itemStack);
        }
        return new ItemRegistry((ImmutableList<ItemStack>)ImmutableList.copyOf(this.itemList), (ImmutableListMultimap<String, ItemStack>)itemsByModIdBuilder.build(), (ImmutableList<ItemStack>)ImmutableList.copyOf(this.potionIngredients), (ImmutableList<ItemStack>)ImmutableList.copyOf(this.fuels), modList);
    }

    private void addItemAndSubItems(@Nullable Item item) {
        if (item == null) {
            return;
        }
        List<ItemStack> items = Internal.getStackHelper().getSubtypes(item, 1);
        for (ItemStack stack : items) {
            if (stack == null) continue;
            this.addItemStack(stack);
        }
    }

    private void addBlockAndSubBlocks(@Nullable Block block) {
        if (block == null) {
            return;
        }
        Item item = Item.func_150898_a((Block)block);
        if (item == null) {
            return;
        }
        for (CreativeTabs itemTab : item.getCreativeTabs()) {
            ArrayList subBlocks = new ArrayList();
            block.func_149666_a(item, itemTab, subBlocks);
            for (ItemStack subBlock : subBlocks) {
                if (subBlock == null) {
                    Log.error("Found null subBlock of {}", block);
                    continue;
                }
                if (subBlock.func_77973_b() == null) {
                    Log.error("Found subBlock of {} with null item", block);
                    continue;
                }
                this.addItemStack(subBlock);
            }
        }
    }

    private void addItemStack(@Nonnull ItemStack stack) {
        StackHelper stackHelper = Internal.getStackHelper();
        try {
            String itemKey = stackHelper.getUniqueIdentifierForStack(stack, StackHelper.UidMode.FULL);
            if (this.itemNameSet.contains(itemKey)) {
                return;
            }
            this.itemNameSet.add(itemKey);
            this.itemList.add(stack);
            String itemWildcardKey = stackHelper.getUniqueIdentifierForStack(stack, StackHelper.UidMode.WILDCARD);
            if (!this.itemWildcardNameSet.contains(itemWildcardKey)) {
                this.itemWildcardNameSet.add(itemWildcardKey);
                this.itemAddedOrder.add(itemWildcardKey);
            }
            if (TileEntityFurnace.func_145954_b((ItemStack)stack)) {
                this.fuels.add(stack);
            }
            if (PotionHelper.func_185205_a((ItemStack)stack)) {
                this.potionIngredients.add(stack);
            }
        }
        catch (RuntimeException e) {
            String stackInfo = ErrorUtil.getItemStackInfo(stack);
            Log.error("Couldn't create unique name for itemStack {}", stackInfo, e);
        }
    }
}

