/*
 * Decompiled with CFR 0.152.
 */
package reborncore.shields.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import reborncore.RebornCore;
import reborncore.shields.FaceShield;
import reborncore.shields.api.ShieldRegistry;
import reborncore.shields.json.ShieldJsonFile;
import reborncore.shields.json.ShieldUser;

public class ShieldJsonLoader {
    public static boolean hasValidJsonFile;
    @Nullable
    public static ShieldJsonFile shieldJsonFile;
    public static HashMap<String, String> customTextureNameList;

    public static void main(String[] args) throws IOException {
        ShieldJsonFile jsonFile = new ShieldJsonFile();
        jsonFile.userList = new ArrayList<ShieldUser>();
        File folder = new File("src/main/resources/assets/reborncore/textures/shields/people/");
        for (File person : folder.listFiles()) {
            jsonFile.userList.add(new ShieldUser(person.getName().replace(".png", "")));
        }
        File output = new File("shields.json");
        System.out.println(output.getAbsolutePath());
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)jsonFile);
        try {
            FileWriter writer = new FileWriter(output);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void load(FMLPreInitializationEvent event) {
        new Thread(() -> {
            try {
                File file = new File(event.getModConfigurationDirectory(), "reborncore/shields.json");
                FileUtils.copyURLToFile((URL)new URL("http://files.modmuss50.me/reborncore/shields2.json"), (File)file);
                if (file.exists()) {
                    Gson gson = new Gson();
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    Type typeOfHashMap = new TypeToken<ShieldJsonFile>(){}.getType();
                    shieldJsonFile = (ShieldJsonFile)gson.fromJson((Reader)reader, typeOfHashMap);
                    hasValidJsonFile = true;
                }
                if (shieldJsonFile != null) {
                    for (ShieldUser user : ShieldJsonLoader.shieldJsonFile.userList) {
                        ShieldRegistry.registerShield(new FaceShield(user.username));
                        if (user.textureName == null) {
                            user.textureName = "";
                        }
                        if (user.textureName.isEmpty()) continue;
                        customTextureNameList.put(user.username, user.textureName);
                    }
                    RebornCore.proxy.loadShieldTextures();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    public static String getMD5(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        String md5 = DigestUtils.md5Hex((InputStream)fis);
        fis.close();
        return md5;
    }

    static {
        customTextureNameList = new HashMap();
    }
}

