/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mcmultipart.capabilities;

import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import reborncore.mcmultipart.capabilities.ICapabilityWrapper;

public class CapabilityWrapperItemHandler
implements ICapabilityWrapper<IItemHandler> {
    @Override
    public Capability<IItemHandler> getCapability() {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public IItemHandler wrapImplementations(Collection<IItemHandler> implementations) {
        for (IItemHandler handler : implementations) {
            if (!(handler instanceof IItemHandlerModifiable)) continue;
            return new WrappedCapabilityItemHandlerModifiable(implementations);
        }
        return new WrappedCapabilityItemHandler(implementations);
    }

    private static class WrappedCapabilityItemHandlerModifiable
    extends WrappedCapabilityItemHandler
    implements IItemHandlerModifiable {
        public WrappedCapabilityItemHandlerModifiable(Collection<IItemHandler> implementations) {
            super(implementations);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            int total = 0;
            for (IItemHandler handler : this.implementations) {
                int slots = handler.getSlots();
                if (slot < total + slots) {
                    if (handler instanceof IItemHandlerModifiable) {
                        ((IItemHandlerModifiable)handler).setStackInSlot(slot - total, stack);
                    } else {
                        return;
                    }
                }
                total += slots;
            }
        }
    }

    private static class WrappedCapabilityItemHandler
    implements IItemHandler {
        protected final Collection<IItemHandler> implementations;

        public WrappedCapabilityItemHandler(Collection<IItemHandler> implementations) {
            this.implementations = implementations;
        }

        public int getSlots() {
            int total = 0;
            for (IItemHandler handler : this.implementations) {
                total += handler.getSlots();
            }
            return total;
        }

        public ItemStack getStackInSlot(int slot) {
            int total = 0;
            for (IItemHandler handler : this.implementations) {
                int slots = handler.getSlots();
                if (slot < total + slots) {
                    return handler.getStackInSlot(slot - total);
                }
                total += slots;
            }
            return null;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            int total = 0;
            for (IItemHandler handler : this.implementations) {
                int slots = handler.getSlots();
                if (slot < total + slots) {
                    return handler.insertItem(slot - total, stack, simulate);
                }
                total += slots;
            }
            return null;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            int total = 0;
            for (IItemHandler handler : this.implementations) {
                int slots = handler.getSlots();
                if (slot < total + slots) {
                    return handler.extractItem(slot - total, amount, simulate);
                }
                total += slots;
            }
            return null;
        }
    }
}

