/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem.traits;

import cofh.api.energy.IEnergyContainerItem;
import net.minecraft.item.ItemStack;
import reborncore.api.power.IEnergyInterfaceItem;
import reborncore.common.RebornCoreConfig;
import reborncore.jtraits.JTrait;

public class RFItemPowerTrait
extends JTrait<IEnergyInterfaceItem>
implements IEnergyContainerItem {
    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!RebornCoreConfig.getRebornPower().rf()) {
            return 0;
        }
        if (!((IEnergyInterfaceItem)this._self).canAcceptEnergy(container)) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - this.getEnergyStored(container), Math.min((int)((IEnergyInterfaceItem)this._self).getMaxTransfer(container) * RebornCoreConfig.euPerRF, maxReceive *= RebornCoreConfig.euPerRF));
        if (!simulate) {
            ((IEnergyInterfaceItem)this._self).setEnergy(((IEnergyInterfaceItem)this._self).getEnergy(container) + (double)energyReceived, container);
        }
        return energyReceived / RebornCoreConfig.euPerRF;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (!RebornCoreConfig.getRebornPower().rf()) {
            return 0;
        }
        if (!((IEnergyInterfaceItem)this._self).canAcceptEnergy(container)) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(container), Math.min(maxExtract *= RebornCoreConfig.euPerRF, maxExtract));
        if (!simulate) {
            ((IEnergyInterfaceItem)this._self).setEnergy(((IEnergyInterfaceItem)this._self).getEnergy(container) - (double)energyExtracted, container);
        }
        return energyExtracted / RebornCoreConfig.euPerRF;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (!RebornCoreConfig.getRebornPower().rf()) {
            return 0;
        }
        return (int)((IEnergyInterfaceItem)this._self).getEnergy(container) / RebornCoreConfig.euPerRF;
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        if (!RebornCoreConfig.getRebornPower().rf()) {
            return 0;
        }
        return (int)((IEnergyInterfaceItem)this._self).getMaxPower(container) / RebornCoreConfig.euPerRF;
    }
}

