/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem.tesla;

import net.darkhax.tesla.capability.TeslaCapabilities;
import net.darkhax.tesla.lib.TeslaUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.powerSystem.tesla.AdvancedTeslaContainer;
import reborncore.common.powerSystem.tesla.ITeslaPowerManager;

public class TeslaPowerManager
implements ITeslaPowerManager {
    AdvancedTeslaContainer container;

    @Override
    public void readFromNBT(NBTTagCompound compound, TilePowerAcceptor powerAcceptor) {
        this.container = new AdvancedTeslaContainer(compound.func_74781_a("TeslaContainer"), powerAcceptor);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound, TilePowerAcceptor powerAcceptor) {
        compound.func_74782_a("TeslaContainer", this.container.writeNBT());
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing, TilePowerAcceptor powerAcceptor) {
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER && powerAcceptor.canAcceptEnergy(facing)) {
            this.container.tile = powerAcceptor;
            return (T)this.container;
        }
        if (capability == TeslaCapabilities.CAPABILITY_PRODUCER && powerAcceptor.canProvideEnergy(facing)) {
            this.container.tile = powerAcceptor;
            return (T)this.container;
        }
        if (capability == TeslaCapabilities.CAPABILITY_HOLDER) {
            this.container.tile = powerAcceptor;
            return (T)this.container;
        }
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing, TilePowerAcceptor powerAcceptor) {
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER && powerAcceptor.canAcceptEnergy(facing)) {
            return true;
        }
        if (capability == TeslaCapabilities.CAPABILITY_PRODUCER && powerAcceptor.canProvideEnergy(facing)) {
            return true;
        }
        return capability == TeslaCapabilities.CAPABILITY_HOLDER;
    }

    @Override
    public void update(TilePowerAcceptor powerAcceptor) {
        if (powerAcceptor.canProvideEnergy(null)) {
            // empty if block
        }
    }

    @Override
    public void created(TilePowerAcceptor powerAcceptor) {
        this.container = new AdvancedTeslaContainer(powerAcceptor);
    }

    @Override
    public String getDisplayableTeslaCount(long tesla) {
        return TeslaUtils.getDisplayableTeslaCount((long)(tesla / (long)RebornCoreConfig.euPerRF));
    }

    public static ITeslaPowerManager getPowerManager() {
        return new TeslaPowerManager();
    }
}

