/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.tesla.TeslaManager;

public class PowerSystem {
    public static String getLocaliszedPower(double eu) {
        return PowerSystem.getLocaliszedPower((int)eu);
    }

    public static String getLocaliszedPower(int eu) {
        if (RebornCoreConfig.getRebornPower().eu()) {
            return PowerSystem.getRoundedString(eu, "EU");
        }
        if (TeslaManager.isTeslaEnabled(RebornCoreConfig.getRebornPower())) {
            return TeslaManager.manager.getDisplayableTeslaCount(eu);
        }
        return PowerSystem.getRoundedString(eu / RebornCoreConfig.euPerRF, "RF");
    }

    private static String getRoundedString(double euValue, String units) {
        if (euValue >= 1000000.0) {
            double tenX = Math.round(euValue / 100000.0);
            return Double.toString(tenX / 10.0).concat(" m " + units);
        }
        if (euValue >= 1000.0) {
            double tenX = Math.round(euValue / 100.0);
            return Double.toString(tenX / 10.0).concat(" k " + units);
        }
        return Double.toString(Math.floor(euValue)).concat(" " + units);
    }
}

