/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import reborncore.RebornRegistry;
import reborncore.common.LootItem;

public class LootManager {
    public static LootManager INSTANCE = new LootManager();

    private LootManager() {
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent evt) {
        LootTable table = evt.getTable();
        InnerPool lp = RebornRegistry.lp;
        if (!lp.isEmpty()) {
            table.addPool((LootPool)lp);
        }
    }

    public static LootItem createLootEntry(Item item, double chance, ResourceLocation loottablelist) {
        return new LootItem(new ItemStack(item), chance, 1, 1, loottablelist);
    }

    public static LootItem createLootEntry(Item item, int minSize, int maxSize, double chance, ResourceLocation loottablelist) {
        return new LootItem(new ItemStack(item), chance, minSize, maxSize, loottablelist);
    }

    public static LootItem createLootEntry(Item item, int ordinal, int minStackSize, int maxStackSize, double chance, ResourceLocation loottablelist) {
        return new LootItem(new ItemStack(item, 1, ordinal), chance, minStackSize, maxStackSize, loottablelist);
    }

    public static class InnerPool
    extends LootPool {
        public final List<LootItem> items = new ArrayList<LootItem>();

        public InnerPool() {
            super(new LootEntry[0], new LootCondition[0], new RandomValueRange(0.0f, 0.0f), new RandomValueRange(0.0f, 0.0f), "reborncore");
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }

        public void addItem(LootItem entry) {
            if (entry != null) {
                this.items.add(entry);
            }
        }

        public void func_186449_b(Collection<ItemStack> stacks, Random rand, LootContext context) {
            for (LootItem entry : this.items) {
                ItemStack stack;
                if (!(rand.nextDouble() < entry.chance) || (stack = entry.createStack(rand)) == null) continue;
                stacks.add(stack);
            }
        }
    }
}

