/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.multiblock.component;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.common.multiblock.CoordTriplet;

public class MultiblockComponent {
    public CoordTriplet relPos;
    public final Block block;
    public final int meta;

    public MultiblockComponent(CoordTriplet relPos, Block block, int meta) {
        this.relPos = relPos;
        this.block = block;
        this.meta = meta;
    }

    public CoordTriplet getRelativePosition() {
        return this.relPos;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public boolean matches(World world, int x, int y, int z) {
        return world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == this.getBlock();
    }

    public ItemStack[] getMaterials() {
        return new ItemStack[]{new ItemStack(this.block, 1, this.meta)};
    }

    public void rotate(double angle) {
        double x = this.relPos.x;
        double z = this.relPos.z;
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double xn = x * cos - z * sin;
        double zn = x * sin + z * cos;
        this.relPos = new CoordTriplet((int)Math.round(xn), this.relPos.y, (int)Math.round(zn));
    }

    public MultiblockComponent copy() {
        return new MultiblockComponent(this.relPos, this.block, this.meta);
    }
}

