/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.IOutputSlot;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.platforms.common.entity.EntityGuiItem;
import shetiphian.platforms.common.helpers.CraftHelper;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.helpers.PlatformHelper;

public class TileEntityPlatFormer
extends TileEntityBase
implements ISidedInventory,
IOutputSlot,
ITickable {
    public InventoryInternal inventory = new InventoryPlatFormer((TileEntity)this);
    private InventoryWrapper inventoryWrapper = new InventoryWrapper((IInventory)this.inventory);
    public byte platformType = 0;
    private ItemStack[] deconstructCache = new ItemStack[4];
    private byte[] craftAmount = new byte[]{4, 2, 0, 2, 4, 4};
    private EntityGuiItem displayItem = null;
    private ItemStack outputItem;

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74774_a("type", this.platformType);
        this.inventory.writeToNBT(nbtTag, "items");
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.platformType = nbtTag.func_74771_c("type");
        this.inventory.readFromNBT(nbtTag, nbtTag.func_74764_b("items") ? "items" : "inventory");
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inventoryWrapper);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        byte needed;
        ItemStack deconStack;
        if (this.outputItem == null) {
            this.updateOutput();
        }
        if ((deconStack = this.inventory.func_70301_a(5)) != null && deconStack.field_77994_a >= (needed = this.getCraftedAmount(deconStack))) {
            this.deconstruct(needed);
        }
    }

    private void deconstruct(int needed) {
        ItemStack deconStack = this.inventory.func_70301_a(5);
        if (deconStack == null) {
            return;
        }
        if (!Function.areItemStacksEqual((ItemStack)this.deconstructCache[0], (ItemStack)deconStack)) {
            this.deconstructCache[0] = deconStack;
            EnumHelper.EnumPlatformMaterial material = EnumHelper.getMaterial(deconStack.func_77952_i());
            NBTTagCompound nbtTag = deconStack.func_77978_p();
            if (nbtTag != null && nbtTag.func_74764_b("texture1") && nbtTag.func_74764_b("texture2")) {
                CraftHelper.MaterialId materialId = CraftHelper.MaterialId.getFor(nbtTag.func_74779_i("texture1"));
                if (materialId != null) {
                    ItemStack itemStack = this.deconstructCache[1] = material == EnumHelper.EnumPlatformMaterial.METAL ? CraftHelper.getIngot(materialId.toStack()) : materialId.toStack();
                }
                if ((materialId = CraftHelper.MaterialId.getFor(nbtTag.func_74779_i("texture2"))) != null) {
                    this.deconstructCache[2] = material == EnumHelper.EnumPlatformMaterial.METAL ? CraftHelper.getIngot(materialId.toStack()) : materialId.toStack();
                }
            }
            this.deconstructCache[3] = material == EnumHelper.EnumPlatformMaterial.WOOD ? new ItemStack(Items.field_151055_y) : new ItemStack(Blocks.field_150411_aY);
        }
        int[] slots = new int[]{-1, -1, -1};
        ItemStack[] temp = (ItemStack[])this.inventory.getContents().clone();
        block0: for (int item = 0; item < 3; item = (int)((byte)(item + 1))) {
            for (int pass = 0; pass < 2; pass = (int)((byte)(pass + 1))) {
                for (int slot = 6; slot < 15; slot = (int)((byte)(slot + 1))) {
                    if (temp[slot] != null) {
                        if (temp[slot].field_77994_a >= temp[slot].func_77976_d() || !Function.areItemStacksEqual((ItemStack)temp[slot], (ItemStack)this.deconstructCache[1 + item])) continue;
                        slots[item] = slot;
                        ++temp[slot].field_77994_a;
                        continue block0;
                    }
                    if (pass != 1) continue;
                    slots[item] = slot;
                    temp[slot] = this.deconstructCache[1 + item].func_77946_l();
                    continue block0;
                }
            }
        }
        if (slots[0] > -1 && slots[1] > -1 && slots[2] > -1) {
            this.inventory.func_70299_a(slots[0], temp[slots[0]]);
            this.inventory.func_70299_a(slots[1], temp[slots[1]]);
            this.inventory.func_70299_a(slots[2], temp[slots[2]]);
            if (deconStack.field_77994_a - needed < 1) {
                deconStack = null;
            } else {
                deconStack.field_77994_a -= needed;
            }
            this.inventory.func_70299_a(5, deconStack);
            this.func_70296_d();
        }
    }

    public void dropItems() {
        for (int slotId = 4; slotId < this.inventory.getContents().length; ++slotId) {
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)this.inventory.func_70301_a(slotId));
        }
    }

    private byte getCraftedAmount(ItemStack stack) {
        int type = stack.func_77952_i() % 10;
        if (type < this.craftAmount.length) {
            return this.craftAmount[type];
        }
        return 0;
    }

    public void updateOutput() {
        this.setGhostSlot(0, this.inventory.func_70301_a(0));
        this.setGhostSlot(1, this.inventory.func_70301_a(1));
        this.setGhostSlot(2, this.inventory.func_70301_a(2));
        EnumHelper.EnumPlatform enumplatform = EnumHelper.getPlatform(this.platformType, this.platformType % 10);
        this.outputItem = PlatformHelper.getStack(enumplatform, this.inventory.func_70301_a(1), this.inventory.func_70301_a(0));
        if (this.outputItem != null) {
            this.outputItem.field_77994_a = this.getCraftedAmount(this.outputItem);
            ItemStack displaystack = this.outputItem.func_77946_l();
            displaystack.func_77964_b(displaystack.func_77952_i());
            displaystack.field_77994_a = 1;
            this.displayItem = new EntityGuiItem(this.func_145831_w(), 0.0, 0.0, 0.0, displaystack);
            this.inventory.func_70299_a(3, this.outputItem.func_77946_l());
        }
    }

    public EntityGuiItem getEntity() {
        if (this.displayItem == null) {
            this.updateOutput();
        }
        return this.displayItem;
    }

    public boolean canCraft() {
        ItemStack[] craftStacks = CraftHelper.getCraftStacks(EnumHelper.getMaterial(this.platformType), this.inventory.func_70301_a(0), this.inventory.func_70301_a(1), this.inventory.func_70301_a(2));
        boolean[] hasItem = new boolean[]{false, false, false};
        for (int slot = 6; slot < 15; slot = (int)((byte)(slot + 1))) {
            ItemStack stack = this.inventory.func_70301_a(slot);
            if (stack == null) continue;
            if (!hasItem[0] && Function.areItemStacksEqual((ItemStack)stack, (ItemStack)craftStacks[0])) {
                hasItem[0] = true;
                if (hasItem[1] || !Function.areItemStacksEqual((ItemStack)craftStacks[0], (ItemStack)craftStacks[1]) || stack.field_77994_a <= 1) continue;
                hasItem[1] = true;
            }
            if (!hasItem[1] && Function.areItemStacksEqual((ItemStack)stack, (ItemStack)craftStacks[1])) {
                hasItem[1] = true;
            }
            if (hasItem[2] || !Function.areItemStacksEqual((ItemStack)stack, (ItemStack)craftStacks[2])) continue;
            hasItem[2] = true;
        }
        return hasItem[0] && hasItem[1] && hasItem[2];
    }

    public void doCraft() {
        ItemStack[] craftStacks = CraftHelper.getCraftStacks(EnumHelper.getMaterial(this.platformType), this.inventory.func_70301_a(0), this.inventory.func_70301_a(1), this.inventory.func_70301_a(2));
        boolean[] hasItem = new boolean[]{false, false, false};
        for (int slot = 6; slot < 15; slot = (int)((byte)(slot + 1))) {
            ItemStack stack = this.inventory.func_70301_a(slot);
            if (stack == null) continue;
            for (int part = 0; part < 3; part = (int)((byte)(part + 1))) {
                if (hasItem[part] || !Function.areItemStacksEqual((ItemStack)stack, (ItemStack)craftStacks[part])) continue;
                hasItem[part] = true;
                if (stack.field_77994_a == 1) {
                    this.inventory.func_70299_a(slot, null);
                    continue;
                }
                --stack.field_77994_a;
                this.inventory.func_70299_a(slot, stack);
            }
        }
    }

    public void setGhostSlot(int slotId, ItemStack stack) {
        if (stack == null) {
            if (slotId >= 0 && slotId < 3) {
                this.inventory.func_70299_a(slotId, null);
            }
            return;
        }
        boolean itemOK = false;
        if (slotId == 0 || slotId == 1) {
            switch (this.platformType / 10) {
                case 0: {
                    itemOK = CraftHelper.isPlanks(stack);
                    break;
                }
                case 1: {
                    itemOK = CraftHelper.isStone(stack);
                    break;
                }
                case 2: {
                    itemOK = CraftHelper.isMetal(stack);
                }
            }
        } else if (slotId == 2) {
            switch (this.platformType / 10) {
                case 0: {
                    itemOK = stack.func_77973_b() == Items.field_151055_y;
                    break;
                }
                default: {
                    boolean bl = itemOK = stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150411_aY);
                }
            }
        }
        if (itemOK) {
            this.inventory.func_70299_a(slotId, stack.func_77946_l().func_77979_a(1));
        } else {
            this.inventory.func_70299_a(slotId, null);
        }
    }

    public boolean canTakeFromOutputSlot(int slotId, EntityPlayer player) {
        return slotId != 3 || player.field_71075_bZ.field_75098_d || this.canCraft();
    }

    public ItemStack decrStackSize(int slotId, EntityPlayer player, int amount) {
        ItemStack stack;
        if (slotId == 3 && player.field_71075_bZ.field_75098_d && (stack = this.inventory.func_70301_a(3)) != null) {
            stack = stack.func_77946_l();
            stack.field_77994_a = 64;
            return stack;
        }
        return null;
    }

    public void onPickupFromOutputSlot(int slotId, EntityPlayer player, ItemStack stack) {
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        return this.inventory.func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int amount) {
        return this.inventory.func_70298_a(slotId, amount);
    }

    public ItemStack func_70304_b(int slotId) {
        return this.inventory.func_70304_b(slotId);
    }

    public void func_70299_a(int slotId, ItemStack stack) {
        this.inventory.func_70299_a(slotId, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public boolean func_94041_b(int slotId, ItemStack stack) {
        return this.inventory.func_94041_b(slotId, stack);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public ITextComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }

    public int[] func_180463_a(EnumFacing face) {
        return new int[]{3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14};
    }

    public boolean func_180462_a(int slotId, ItemStack stack, EnumFacing face) {
        return slotId > 5;
    }

    public boolean func_180461_b(int slotId, ItemStack stack, EnumFacing face) {
        return slotId == 4 || slotId == 3 && this.inventory.func_70301_a(4) == null;
    }

    private class InventoryWrapper
    extends InvWrapper {
        private InventoryWrapper(IInventory inv) {
            super(inv);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return slot > 5 ? super.insertItem(slot, stack, simulate) : stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot == 4 || slot == 3 && this.getInv().func_70301_a(4) == null ? super.extractItem(slot, amount, simulate) : null;
        }
    }

    private class InventoryPlatFormer
    extends InventoryInternal {
        private InventoryPlatFormer(TileEntity invOwner) {
            super(invOwner, "internal", 15);
        }

        public ItemStack func_70298_a(int slotId, int amount) {
            if (slotId == 3) {
                if (this.contents[4] == null && TileEntityPlatFormer.this.canCraft()) {
                    TileEntityPlatFormer.this.doCraft();
                    ItemStack stack = TileEntityPlatFormer.this.outputItem.func_77946_l();
                    if (stack.field_77994_a <= amount) {
                        this.func_70296_d();
                        return stack;
                    }
                    this.contents[4] = TileEntityPlatFormer.this.outputItem.func_77946_l();
                    return this.func_70298_a(4, amount);
                }
                return null;
            }
            ItemStack stack = this.func_70301_a(slotId);
            if (stack != null) {
                if (stack.field_77994_a <= amount) {
                    this.contents[slotId] = null;
                    this.func_70296_d();
                    return stack;
                }
                stack = stack.func_77979_a(amount);
                if (this.contents[slotId] != null && this.contents[slotId].field_77994_a < 1) {
                    this.contents[slotId] = null;
                }
                this.func_70296_d();
                return stack;
            }
            return null;
        }

        public boolean func_94041_b(int slotId, ItemStack stack) {
            return slotId > 4;
        }
    }
}

