/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.helpers;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformTypes;
import shetiphian.platforms.common.tileentity.TileEntityTypeBase;
import shetiphian.platforms.common.tileentity.TileEntityTypeBaseWithRail;

public class TileHelper {
    public static TileEntityTypeBase getPlatformTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityTypeBase ? (TileEntityTypeBase)tile : null;
    }

    public static boolean hasRail(TileEntityTypeBase tile) {
        return tile instanceof TileEntityTypeBaseWithRail && ((TileEntityTypeBaseWithRail)tile).hasRail();
    }

    public static EnumHelper.EnumPlatform getRail(TileEntityTypeBase tile) {
        if (TileHelper.hasRail(tile)) {
            return ((TileEntityTypeBaseWithRail)tile).getRail();
        }
        return null;
    }

    public static boolean setRail(TileEntityTypeBase tile, int railType) {
        return tile instanceof TileEntityTypeBaseWithRail && ((TileEntityTypeBaseWithRail)tile).setRail(railType);
    }

    public static boolean setRail(TileEntityTypeBase tile, EnumHelper.EnumPlatform enumPlatform) {
        return tile instanceof TileEntityTypeBaseWithRail && ((TileEntityTypeBaseWithRail)tile).setRail(enumPlatform);
    }

    public static boolean removeRail(TileEntityTypeBase tile) {
        if (TileHelper.hasRail(tile)) {
            ((TileEntityTypeBaseWithRail)tile).removeRail();
            return true;
        }
        return false;
    }

    public static boolean hasTorch(TileEntityTypeBase tile) {
        return tile instanceof TileEntityPlatformTypes.TileEntityPlatformFrame && ((TileEntityPlatformTypes.TileEntityPlatformFrame)tile).getTorchType() != EnumHelper.EnumPlatformTorch.NONE;
    }

    public static EnumHelper.EnumPlatformTorch getTorch(TileEntityTypeBase tile) {
        if (TileHelper.hasTorch(tile)) {
            return ((TileEntityPlatformTypes.TileEntityPlatformFrame)tile).getTorchType();
        }
        return null;
    }

    public static boolean setTorch(TileEntityTypeBase tile, EnumHelper.EnumPlatformTorch torchType) {
        return tile instanceof TileEntityPlatformTypes.TileEntityPlatformFrame && ((TileEntityPlatformTypes.TileEntityPlatformFrame)tile).setTorchType(torchType);
    }

    public static boolean removeTorch(TileEntityTypeBase tile) {
        if (TileHelper.hasTorch(tile)) {
            ((TileEntityPlatformTypes.TileEntityPlatformFrame)tile).removeTorch();
            return true;
        }
        return false;
    }

    public static byte getType(TileEntityTypeBase tile) {
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformFlat) {
            return ((TileEntityPlatformTypes.TileEntityPlatformFlat)tile).getFlatType();
        }
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRamp) {
            return ((TileEntityPlatformTypes.TileEntityPlatformRamp)tile).getRampType();
        }
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRise) {
            return ((TileEntityPlatformTypes.TileEntityPlatformRise)tile).getRiseType();
        }
        return -1;
    }

    public static void setType(TileEntityTypeBase tile, int type) {
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformFlat) {
            ((TileEntityPlatformTypes.TileEntityPlatformFlat)tile).setFlatType(type);
        } else if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRamp) {
            ((TileEntityPlatformTypes.TileEntityPlatformRamp)tile).setRampType(type);
        } else if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRise) {
            ((TileEntityPlatformTypes.TileEntityPlatformRise)tile).setRiseType(type);
        }
    }

    public static byte getAltSupport(TileEntityTypeBase tile) {
        return tile instanceof TileEntityPlatformTypes.TileEntityPlatformRamp ? ((TileEntityPlatformTypes.TileEntityPlatformRamp)tile).getAltSupport() : (byte)0;
    }

    public static void setAltSupport(TileEntityTypeBase tile, int altSupport) {
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRamp) {
            ((TileEntityPlatformTypes.TileEntityPlatformRamp)tile).setAltSupport(altSupport);
        }
    }
}

