/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.helpers;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.platforms.common.helpers.EnumHelper;

public class CraftHelper {
    public static Set<MaterialId> PLANKS = CraftHelper.generatePlankLookup();
    public static Set<MaterialId> STONE = CraftHelper.generateStoneLookup();
    public static Map<MaterialId, MaterialId> METAL = CraftHelper.generateIngotLookup();

    public static ItemStack[] getCraftStacks(EnumHelper.EnumPlatformMaterial material, ItemStack floor_brace, ItemStack joist_strut, ItemStack support) {
        ItemStack[] ret = new ItemStack[]{floor_brace, joist_strut, support};
        if (ret[0] == null) {
            ret[0] = material.getPriItem();
        }
        if (ret[1] == null) {
            ret[1] = material.getPriItem();
        }
        if (ret[2] == null) {
            ret[2] = material.getSecItem();
        }
        return ret;
    }

    public static boolean isPlanks(ItemStack stack) {
        for (int check = 0; check < 2; ++check) {
            MaterialId mId = MaterialId.getFor(stack, check == 1);
            if (mId == null || !PLANKS.contains(mId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStone(ItemStack stack) {
        for (int check = 0; check < 2; ++check) {
            MaterialId mId = MaterialId.getFor(stack, check == 1);
            if (mId == null || !STONE.contains(mId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMetal(ItemStack stack) {
        for (int check = 0; check < 2; ++check) {
            MaterialId mId = MaterialId.getFor(stack, check == 1);
            if (mId == null || !METAL.containsKey(mId)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getOreBlock(ItemStack ingot) {
        for (int check = 0; check < 2; ++check) {
            MaterialId mId = MaterialId.getFor(ingot, check == 1);
            if (mId == null || !METAL.containsKey(mId)) continue;
            return METAL.get(mId).toStack();
        }
        return null;
    }

    public static ItemStack getIngot(ItemStack oreBlock) {
        for (int check = 0; check < 2; ++check) {
            MaterialId mIdBlock = MaterialId.getFor(oreBlock, check == 1);
            if (mIdBlock == null) continue;
            for (Map.Entry<MaterialId, MaterialId> entry : METAL.entrySet()) {
                if (!entry.getValue().equals(mIdBlock)) continue;
                return entry.getKey().toStack();
            }
        }
        return null;
    }

    private static Set<MaterialId> generatePlankLookup() {
        HashSet<MaterialId> set = new HashSet<MaterialId>();
        for (ItemStack stack : OreDictionary.getOres((String)"plankWood")) {
            CraftHelper.addStack(set, stack);
        }
        return set;
    }

    private static Set<MaterialId> generateStoneLookup() {
        Block[] blocks;
        String[] oreIds;
        OreDictionary.registerOre((String)"sandstone", (ItemStack)new ItemStack(Blocks.field_180395_cM, 1, Short.MAX_VALUE));
        HashSet<MaterialId> set = new HashSet<MaterialId>();
        for (String oreId : oreIds = new String[]{"stone", "cobblestone", "sandstone"}) {
            for (ItemStack stack : OreDictionary.getOres((String)oreId)) {
                CraftHelper.addStack(set, stack);
            }
        }
        for (Block block : blocks = new Block[]{Blocks.field_150348_b, Blocks.field_150347_e, Blocks.field_150341_Y, Blocks.field_150336_V, Blocks.field_150377_bs, Blocks.field_150405_ch, Blocks.field_150406_ce, Blocks.field_180397_cI, Blocks.field_150385_bj, Blocks.field_150417_aV, Blocks.field_150403_cj, Blocks.field_150371_ca, Blocks.field_150368_y, Blocks.field_150484_ah, Blocks.field_150475_bE}) {
            CraftHelper.addStack(set, new ItemStack(block, 1, Short.MAX_VALUE));
        }
        return set;
    }

    private static void addStack(Set<MaterialId> set, ItemStack stack) {
        MaterialId mId = MaterialId.getFor(stack, stack.func_77952_i() == Short.MAX_VALUE);
        if (mId != null) {
            set.add(mId);
        }
    }

    private static Map<MaterialId, MaterialId> generateIngotLookup() {
        String[] names;
        HashMap<MaterialId, MaterialId> mapLookup = new HashMap<MaterialId, MaterialId>();
        for (String name : names = OreDictionary.getOreNames()) {
            if (Strings.isNullOrEmpty((String)name) || !name.startsWith("ingot")) continue;
            CraftHelper.processOreName(mapLookup, name);
        }
        return mapLookup;
    }

    private static void processOreName(Map<MaterialId, MaterialId> mapLookup, String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return;
        }
        List listIngots = OreDictionary.getOres((String)name);
        if (listIngots == null || listIngots.isEmpty()) {
            return;
        }
        List listOreBlocks = OreDictionary.getOres((String)(name = name.replace("ingot", "block")));
        if (listOreBlocks == null || listOreBlocks.isEmpty()) {
            return;
        }
        MaterialId mIdDefaultBlock = null;
        ArrayList<MaterialId> unmappedIngots = new ArrayList<MaterialId>();
        for (ItemStack oreblock : listOreBlocks) {
            MaterialId mIdBlock = MaterialId.getFor(oreblock, false);
            if (mIdBlock == null) continue;
            if (mIdDefaultBlock == null) {
                mIdDefaultBlock = mIdBlock;
            }
            for (ItemStack ingot : listIngots) {
                MaterialId mIdIngot = MaterialId.getFor(ingot, false);
                if (mIdIngot == null) continue;
                if (listOreBlocks.size() == 1) {
                    mapLookup.put(mIdIngot, mIdBlock);
                    continue;
                }
                if (mIdBlock.compareMod(mIdIngot)) {
                    mapLookup.put(mIdIngot, mIdBlock);
                    unmappedIngots.remove(mIdIngot);
                    continue;
                }
                unmappedIngots.add(mIdIngot);
            }
        }
        for (MaterialId mIdIngot : unmappedIngots) {
            mapLookup.put(mIdIngot, mIdDefaultBlock);
        }
    }

    public static class MaterialId {
        private final String mod;
        private final String name;
        private final int meta;

        private MaterialId(String mod, String name, int meta) {
            this.mod = mod;
            this.name = name;
            this.meta = meta;
        }

        static MaterialId getFor(ItemStack stack, boolean anyMeta) {
            if (stack != null) {
                ResourceLocation location = GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)stack.func_77973_b());
                return location == null ? null : new MaterialId(location.func_110624_b(), location.func_110623_a(), anyMeta ? Short.MAX_VALUE : stack.func_77952_i());
            }
            return null;
        }

        public static MaterialId getFor(String id) {
            String mod = "minecraft";
            String name = "planks";
            int meta = 0;
            if (!Strings.isNullOrEmpty((String)id)) {
                String[] split = id.split(":");
                try {
                    mod = split[0];
                    name = split[1];
                    meta = Integer.parseInt(split[2]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new MaterialId(mod, name, meta);
        }

        boolean compareMod(MaterialId mId) {
            return mId.mod.equals(this.mod);
        }

        public ItemStack toStack() {
            Item item = GameRegistry.findItem((String)this.mod, (String)this.name);
            return item == null ? null : new ItemStack(item, 1, this.meta);
        }

        public String toString() {
            return this.mod + ":" + this.name + ":" + this.meta;
        }

        public boolean equals(Object obj) {
            return obj instanceof MaterialId && obj.toString().equals(this.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

