/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.recipe.FallbackShapedOreRecipe;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeStatus;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeStorage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModRecipes {
    public static ItemStack makeBasicDrawerItemStack(EnumBasicDrawer info, String material, int count) {
        ItemStack stack = new ItemStack((Block)ModBlocks.basicDrawers, count, info.getMetadata());
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("material", material);
        stack.func_77982_d(data);
        return stack;
    }

    public static ItemStack makeCustomDrawerItemStack(EnumBasicDrawer info, int count) {
        return new ItemStack((Block)ModBlocks.customDrawers, count, info.getMetadata());
    }

    public void init() {
        ItemStack result;
        ConfigManager config = StorageDrawers.config;
        RecipeSorter.register((String)"StorageDrawers:FallbackShapedOreRecipe", FallbackShapedOreRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:forge:shapedore");
        for (BlockPlanks.EnumType material : BlockPlanks.EnumType.values()) {
            ItemStack result2;
            if (config.isBlockEnabled(EnumBasicDrawer.FULL1.getUnlocalizedName())) {
                result2 = ModRecipes.makeBasicDrawerItemStack(EnumBasicDrawer.FULL1, material.func_176610_l(), config.getBlockRecipeOutput(EnumBasicDrawer.FULL1.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result2, new Object[]{"xxx", " y ", "xxx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, material.func_176839_a()), Character.valueOf('y'), "chestWood"}));
            }
            if (config.isBlockEnabled(EnumBasicDrawer.FULL2.getUnlocalizedName())) {
                result2 = ModRecipes.makeBasicDrawerItemStack(EnumBasicDrawer.FULL2, material.func_176610_l(), config.getBlockRecipeOutput(EnumBasicDrawer.FULL2.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result2, new Object[]{"xyx", "xxx", "xyx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, material.func_176839_a()), Character.valueOf('y'), "chestWood"}));
            }
            if (config.isBlockEnabled(EnumBasicDrawer.FULL4.getUnlocalizedName())) {
                result2 = ModRecipes.makeBasicDrawerItemStack(EnumBasicDrawer.FULL4, material.func_176610_l(), config.getBlockRecipeOutput(EnumBasicDrawer.FULL4.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result2, new Object[]{"yxy", "xxx", "yxy", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, material.func_176839_a()), Character.valueOf('y'), "chestWood"}));
            }
            if (config.isBlockEnabled(EnumBasicDrawer.HALF2.getUnlocalizedName())) {
                result2 = ModRecipes.makeBasicDrawerItemStack(EnumBasicDrawer.HALF2, material.func_176610_l(), config.getBlockRecipeOutput(EnumBasicDrawer.HALF2.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result2, new Object[]{"xyx", "xxx", "xyx", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150376_bx, 1, material.func_176839_a()), Character.valueOf('y'), "chestWood"}));
            }
            if (config.isBlockEnabled(EnumBasicDrawer.HALF4.getUnlocalizedName())) {
                result2 = ModRecipes.makeBasicDrawerItemStack(EnumBasicDrawer.HALF4, material.func_176610_l(), config.getBlockRecipeOutput(EnumBasicDrawer.HALF4.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result2, new Object[]{"yxy", "xxx", "yxy", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150376_bx, 1, material.func_176839_a()), Character.valueOf('y'), "chestWood"}));
            }
            if (!config.isBlockEnabled("trim")) continue;
            result2 = new ItemStack((Block)ModBlocks.trim, config.getBlockRecipeOutput("trim"), material.func_176839_a());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result2, new Object[]{"xyx", "yyy", "xyx", Character.valueOf('x'), "stickWood", Character.valueOf('y'), new ItemStack(Blocks.field_150344_f, 1, material.func_176839_a())}));
        }
        if (config.cache.enableFallbackRecipes) {
            if (config.isBlockEnabled(EnumBasicDrawer.FULL1.getUnlocalizedName())) {
                result = ModRecipes.makeBasicDrawerItemStack(EnumBasicDrawer.FULL1, BlockPlanks.EnumType.OAK.func_176610_l(), config.getBlockRecipeOutput(EnumBasicDrawer.FULL1.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new FallbackShapedOreRecipe(result, "xxx", " y ", "xxx", Character.valueOf('x'), "plankWood", Character.valueOf('y'), "chestWood"));
            }
            if (config.isBlockEnabled(EnumBasicDrawer.FULL2.getUnlocalizedName())) {
                result = ModRecipes.makeBasicDrawerItemStack(EnumBasicDrawer.FULL2, BlockPlanks.EnumType.OAK.func_176610_l(), config.getBlockRecipeOutput(EnumBasicDrawer.FULL2.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new FallbackShapedOreRecipe(result, "xyx", "xxx", "xyx", Character.valueOf('x'), "plankWood", Character.valueOf('y'), "chestWood"));
            }
            if (config.isBlockEnabled(EnumBasicDrawer.FULL4.getUnlocalizedName())) {
                result = ModRecipes.makeBasicDrawerItemStack(EnumBasicDrawer.FULL4, BlockPlanks.EnumType.OAK.func_176610_l(), config.getBlockRecipeOutput(EnumBasicDrawer.FULL4.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new FallbackShapedOreRecipe(result, "yxy", "xxx", "yxy", Character.valueOf('x'), "plankWood", Character.valueOf('y'), "chestWood"));
            }
            if (config.isBlockEnabled(EnumBasicDrawer.HALF2.getUnlocalizedName())) {
                result = ModRecipes.makeBasicDrawerItemStack(EnumBasicDrawer.HALF2, BlockPlanks.EnumType.OAK.func_176610_l(), config.getBlockRecipeOutput(EnumBasicDrawer.HALF2.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new FallbackShapedOreRecipe(result, "xyx", "xxx", "xyx", Character.valueOf('x'), "slabWood", Character.valueOf('y'), "chestWood"));
            }
            if (config.isBlockEnabled(EnumBasicDrawer.HALF4.getUnlocalizedName())) {
                result = ModRecipes.makeBasicDrawerItemStack(EnumBasicDrawer.HALF4, BlockPlanks.EnumType.OAK.func_176610_l(), config.getBlockRecipeOutput(EnumBasicDrawer.HALF4.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new FallbackShapedOreRecipe(result, "yxy", "xxx", "yxy", Character.valueOf('x'), "slabWood", Character.valueOf('y'), "chestWood"));
            }
            if (config.isBlockEnabled("trim")) {
                result = new ItemStack((Block)ModBlocks.trim, config.getBlockRecipeOutput("trim"), BlockPlanks.EnumType.OAK.func_176839_a());
                GameRegistry.addRecipe((IRecipe)new FallbackShapedOreRecipe(result, "xyx", "yyy", "xyx", Character.valueOf('x'), "stickWood", Character.valueOf('y'), "slabWood"));
            }
        }
        if (config.isBlockEnabled("compdrawers")) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.compDrawers, config.getBlockRecipeOutput("compdrawers")), new Object[]{"xxx", "zwz", "xyx", Character.valueOf('x'), new ItemStack(Blocks.field_150348_b), Character.valueOf('y'), "ingotIron", Character.valueOf('z'), new ItemStack((Block)Blocks.field_150331_J), Character.valueOf('w'), "drawerBasic"}));
        }
        if (config.isBlockEnabled("controller")) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.controller), new Object[]{"xxx", "yzy", "xwx", Character.valueOf('x'), new ItemStack(Blocks.field_150348_b), Character.valueOf('y'), Items.field_151132_bS, Character.valueOf('z'), "drawerBasic", Character.valueOf('w'), "gemDiamond"}));
        }
        if (config.isBlockEnabled("controllerSlave")) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.controllerSlave), new Object[]{"xxx", "yzy", "xwx", Character.valueOf('x'), new ItemStack(Blocks.field_150348_b), Character.valueOf('y'), Items.field_151132_bS, Character.valueOf('z'), "drawerBasic", Character.valueOf('w'), "ingotGold"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModItems.upgradeTemplate, 2), new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), "stickWood", Character.valueOf('y'), new ItemStack((Block)ModBlocks.basicDrawers, 1, Short.MAX_VALUE)}));
        if (config.cache.enableStorageUpgrades) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeStorage, 1, EnumUpgradeStorage.IRON.getMetadata()), new Object[]{"xyx", "yzy", "xyx", Character.valueOf('x'), "ingotIron", Character.valueOf('y'), "stickWood", Character.valueOf('z'), ModItems.upgradeTemplate}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeStorage, 1, EnumUpgradeStorage.GOLD.getMetadata()), new Object[]{"xyx", "yzy", "xyx", Character.valueOf('x'), "ingotGold", Character.valueOf('y'), "stickWood", Character.valueOf('z'), ModItems.upgradeTemplate}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeStorage, 1, EnumUpgradeStorage.OBSIDIAN.getMetadata()), new Object[]{"xyx", "yzy", "xyx", Character.valueOf('x'), Blocks.field_150343_Z, Character.valueOf('y'), "stickWood", Character.valueOf('z'), ModItems.upgradeTemplate}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeStorage, 1, EnumUpgradeStorage.DIAMOND.getMetadata()), new Object[]{"xyx", "yzy", "xyx", Character.valueOf('x'), "gemDiamond", Character.valueOf('y'), "stickWood", Character.valueOf('z'), ModItems.upgradeTemplate}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeStorage, 1, EnumUpgradeStorage.EMERALD.getMetadata()), new Object[]{"xyx", "yzy", "xyx", Character.valueOf('x'), "gemEmerald", Character.valueOf('y'), "stickWood", Character.valueOf('z'), ModItems.upgradeTemplate}));
        }
        if (config.cache.enableIndicatorUpgrades) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeStatus, 1, EnumUpgradeStatus.LEVEL1.getMetadata()), new Object[]{"wyw", "yzy", "xyx", Character.valueOf('w'), new ItemStack(Blocks.field_150429_aA), Character.valueOf('x'), "dustRedstone", Character.valueOf('y'), "stickWood", Character.valueOf('z'), ModItems.upgradeTemplate}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeStatus, 1, EnumUpgradeStatus.LEVEL2.getMetadata()), new Object[]{"wyw", "yzy", "xyx", Character.valueOf('w'), Items.field_151132_bS, Character.valueOf('x'), "dustRedstone", Character.valueOf('y'), "stickWood", Character.valueOf('z'), ModItems.upgradeTemplate}));
        }
        if (config.cache.enableLockUpgrades) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.drawerKey), new Object[]{"xy ", " y ", " z ", Character.valueOf('x'), "nuggetGold", Character.valueOf('y'), "ingotGold", Character.valueOf('z'), ModItems.upgradeTemplate}));
        }
        if (config.cache.enableVoidUpgrades) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeVoid), new Object[]{"yyy", "xzx", "yyy", Character.valueOf('x'), Blocks.field_150343_Z, Character.valueOf('y'), "stickWood", Character.valueOf('z'), ModItems.upgradeTemplate}));
        }
        if (config.cache.enableRedstoneUpgrades) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeRedstone, 1, 0), new Object[]{"xyx", "yzy", "xyx", Character.valueOf('x'), "dustRedstone", Character.valueOf('y'), "stickWood", Character.valueOf('z'), ModItems.upgradeTemplate}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeRedstone, 1, 1), new Object[]{"xxx", "yzy", "yyy", Character.valueOf('x'), "dustRedstone", Character.valueOf('y'), "stickWood", Character.valueOf('z'), ModItems.upgradeTemplate}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.upgradeRedstone, 1, 2), new Object[]{"yyy", "yzy", "xxx", Character.valueOf('x'), "dustRedstone", Character.valueOf('y'), "stickWood", Character.valueOf('z'), ModItems.upgradeTemplate}));
        }
        if (config.cache.enableShroudUpgrades) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ModItems.shroudKey), (Object[])new Object[]{ModItems.drawerKey, Items.field_151061_bv});
        }
        if (config.cache.enablePersonalUpgrades) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ModItems.personalKey), (Object[])new Object[]{ModItems.drawerKey, Items.field_151057_cb});
        }
        if (config.cache.enableTape) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.tape), new Object[]{" x ", "yyy", Character.valueOf('x'), "slimeball", Character.valueOf('y'), Items.field_151121_aF}));
        }
        if (config.cache.enableFramedDrawers) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)ModBlocks.framingTable), (Object[])new Object[]{"xxx", "x x", Character.valueOf('x'), ModBlocks.trim});
            if (config.isBlockEnabled("fulldrawers1")) {
                result = ModRecipes.makeCustomDrawerItemStack(EnumBasicDrawer.FULL1, config.getBlockRecipeOutput(EnumBasicDrawer.FULL1.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, new Object[]{"xxx", " y ", "xxx", Character.valueOf('x'), "stickWood", Character.valueOf('y'), "chestWood"}));
            }
            if (config.isBlockEnabled("fulldrawers2")) {
                result = ModRecipes.makeCustomDrawerItemStack(EnumBasicDrawer.FULL2, config.getBlockRecipeOutput(EnumBasicDrawer.FULL2.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, new Object[]{"xyx", "xzx", "xyx", Character.valueOf('x'), "stickWood", Character.valueOf('y'), "chestWood", Character.valueOf('z'), "plankWood"}));
            }
            if (config.isBlockEnabled("halfdrawers2")) {
                result = ModRecipes.makeCustomDrawerItemStack(EnumBasicDrawer.HALF2, config.getBlockRecipeOutput(EnumBasicDrawer.HALF2.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, new Object[]{"xyx", "xzx", "xyx", Character.valueOf('x'), "stickWood", Character.valueOf('y'), "chestWood", Character.valueOf('z'), "slabWood"}));
            }
            if (config.isBlockEnabled("fulldrawers4")) {
                result = ModRecipes.makeCustomDrawerItemStack(EnumBasicDrawer.FULL4, config.getBlockRecipeOutput(EnumBasicDrawer.FULL4.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, new Object[]{"yxy", "xzx", "yxy", Character.valueOf('x'), "stickWood", Character.valueOf('y'), "chestWood", Character.valueOf('z'), "plankWood"}));
            }
            if (config.isBlockEnabled("halfdrawers4")) {
                result = ModRecipes.makeCustomDrawerItemStack(EnumBasicDrawer.HALF4, config.getBlockRecipeOutput(EnumBasicDrawer.HALF4.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, new Object[]{"yxy", "xzx", "yxy", Character.valueOf('x'), "stickWood", Character.valueOf('y'), "chestWood", Character.valueOf('z'), "slabWood"}));
            }
            if (config.isBlockEnabled("trim")) {
                result = new ItemStack((Block)ModBlocks.customTrim, config.getBlockRecipeOutput("trim"));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, new Object[]{"yxy", "xyx", "yxy", Character.valueOf('x'), "stickWood", Character.valueOf('y'), "plankWood"}));
            }
        }
    }
}

