/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager;

import ipsis.woot.manager.EnumEnchantKey;
import ipsis.woot.manager.EnumSpawnerUpgrade;

public class SpawnerUpgrade {
    EnumSpawnerUpgrade upgradeType;
    int rfCostPerTick;
    int v;

    public String toString() {
        return (Object)((Object)this.upgradeType) + " pwr:" + this.rfCostPerTick + " v:" + this.v;
    }

    public SpawnerUpgrade(EnumSpawnerUpgrade upgradeType) {
        this.upgradeType = upgradeType;
        this.rfCostPerTick = 1;
        this.v = 0;
    }

    public SpawnerUpgrade setRfCostPerTick(int rfCostPerTick) {
        this.rfCostPerTick = rfCostPerTick;
        return this;
    }

    public int getRfCostPerTick() {
        return this.rfCostPerTick;
    }

    public SpawnerUpgrade setSpawnRate(int spawnRate) {
        this.v = spawnRate;
        return this;
    }

    public int getSpawnRate() {
        return this.v;
    }

    public SpawnerUpgrade setMass(int mass) {
        this.v = mass;
        return this;
    }

    public int getMass() {
        return this.v;
    }

    public SpawnerUpgrade setDecapitateChance(int decapitateChance) {
        this.v = decapitateChance;
        return this;
    }

    public int getDecapitateChance() {
        return this.v;
    }

    public SpawnerUpgrade setXpBoost(int boost) {
        this.v = boost;
        return this;
    }

    public int getXpBoost() {
        return this.v;
    }

    public SpawnerUpgrade setEfficiency(int percentage) {
        this.v = percentage;
        return this;
    }

    public int getEfficiency() {
        return this.v;
    }

    public EnumSpawnerUpgrade getUpgradeType() {
        return this.upgradeType;
    }

    public EnumEnchantKey getEnchantKey() {
        if (this.upgradeType == EnumSpawnerUpgrade.LOOTING_I) {
            return EnumEnchantKey.LOOTING_I;
        }
        if (this.upgradeType == EnumSpawnerUpgrade.LOOTING_II) {
            return EnumEnchantKey.LOOTING_II;
        }
        if (this.upgradeType == EnumSpawnerUpgrade.LOOTING_III) {
            return EnumEnchantKey.LOOTING_III;
        }
        return EnumEnchantKey.NO_ENCHANT;
    }

    public boolean isLooting() {
        return this.upgradeType == EnumSpawnerUpgrade.LOOTING_I || this.upgradeType == EnumSpawnerUpgrade.LOOTING_II || this.upgradeType == EnumSpawnerUpgrade.LOOTING_III;
    }

    public boolean isRate() {
        return this.upgradeType == EnumSpawnerUpgrade.RATE_I || this.upgradeType == EnumSpawnerUpgrade.RATE_II || this.upgradeType == EnumSpawnerUpgrade.RATE_III;
    }

    public boolean isXp() {
        return this.upgradeType == EnumSpawnerUpgrade.XP_I || this.upgradeType == EnumSpawnerUpgrade.XP_II || this.upgradeType == EnumSpawnerUpgrade.XP_III;
    }

    public boolean isMass() {
        return this.upgradeType == EnumSpawnerUpgrade.MASS_I || this.upgradeType == EnumSpawnerUpgrade.MASS_II || this.upgradeType == EnumSpawnerUpgrade.MASS_III;
    }

    public boolean isDecapitate() {
        return this.upgradeType == EnumSpawnerUpgrade.DECAPITATE_I || this.upgradeType == EnumSpawnerUpgrade.DECAPITATE_II || this.upgradeType == EnumSpawnerUpgrade.DECAPITATE_III;
    }

    public boolean isEfficiency() {
        return this.upgradeType == EnumSpawnerUpgrade.EFFICIENCY_I || this.upgradeType == EnumSpawnerUpgrade.EFFICIENCY_II || this.upgradeType == EnumSpawnerUpgrade.EFFICIENCY_III;
    }

    public int getUpgradeTier() {
        int tier;
        switch (this.upgradeType) {
            case LOOTING_I: 
            case RATE_I: 
            case XP_I: 
            case MASS_I: 
            case DECAPITATE_I: 
            case EFFICIENCY_I: {
                tier = 1;
                break;
            }
            case LOOTING_II: 
            case RATE_II: 
            case XP_II: 
            case MASS_II: 
            case DECAPITATE_II: 
            case EFFICIENCY_II: {
                tier = 2;
                break;
            }
            case LOOTING_III: 
            case RATE_III: 
            case XP_III: 
            case MASS_III: 
            case DECAPITATE_III: 
            case EFFICIENCY_III: {
                tier = 3;
                break;
            }
            default: {
                tier = 0;
            }
        }
        return tier;
    }
}

