/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager;

import ipsis.woot.tileentity.TileEntityMobFactory;
import ipsis.woot.tileentity.TileEntityMobFactoryExtender;
import ipsis.woot.tileentity.TileEntityMobFactoryProxy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ProxyManager {
    boolean validProxy = false;
    TileEntityMobFactory factory;
    List<TileEntityMobFactoryExtender> extenderList = new ArrayList<TileEntityMobFactoryExtender>();
    TileEntityMobFactoryProxy proxy = null;

    public ProxyManager(TileEntityMobFactory factory) {
        this();
        this.factory = factory;
    }

    private ProxyManager() {
    }

    public boolean isValidProxy() {
        return this.validProxy;
    }

    public List<TileEntityMobFactoryExtender> getExtenderList() {
        return this.extenderList;
    }

    public void scanProxy() {
        this.proxy = null;
        this.extenderList.clear();
        this.validProxy = false;
        BlockPos blockPos = this.factory.func_174877_v().func_177979_c(1);
        TileEntity te = this.factory.func_145831_w().func_175625_s(blockPos);
        while (te != null && te instanceof TileEntityMobFactoryExtender) {
            this.extenderList.add((TileEntityMobFactoryExtender)te);
            blockPos = blockPos.func_177979_c(1);
            te = this.factory.func_145831_w().func_175625_s(blockPos);
        }
        if (te != null && te instanceof TileEntityMobFactoryProxy) {
            this.proxy = (TileEntityMobFactoryProxy)te;
        }
        if (this.proxy != null && this.extenderList.size() >= 1) {
            this.validProxy = true;
            this.setMaster(true);
        }
    }

    public void setMaster(boolean connected) {
        if (this.proxy != null) {
            if (connected) {
                this.proxy.setMaster(this.factory);
            } else {
                this.proxy.clearMaster();
            }
        }
        for (TileEntityMobFactoryExtender te : this.extenderList) {
            if (connected) {
                te.setMaster(this.factory);
                continue;
            }
            te.clearMaster();
        }
    }

    public List<IItemHandler> getIItemHandlers() {
        ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
        if (this.validProxy && this.proxy != null) {
            for (EnumFacing f : EnumFacing.field_82609_l) {
                TileEntity te;
                if (f == EnumFacing.UP) continue;
                BlockPos pos = this.proxy.func_174877_v().func_177972_a(f);
                if (!this.factory.func_145831_w().func_175667_e(pos) || (te = this.factory.func_145831_w().func_175625_s(pos)) == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d())) continue;
                handlers.add((IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d()));
            }
        }
        return handlers;
    }
}

