/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager;

import ipsis.Woot;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.reference.Settings;
import ipsis.woot.util.StringHelper;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class MobRegistry {
    public static final String INVALID_MOB_NAME = "InvalidMob";
    public static final String ENDER_DRAGON = "Woot:none:EnderDragon";
    HashMap<String, MobInfo> mobInfoHashMap = new HashMap();
    HashMap<String, Integer> mobCostMap = new HashMap();

    public static String getMcName(String wootName) {
        return wootName.substring(wootName.lastIndexOf(58) + 1);
    }

    public boolean isValidMobName(String mobName) {
        return mobName != null && !mobName.equals(INVALID_MOB_NAME) && !mobName.equals("");
    }

    public void addCosting(String mobName, int cost) {
        if (mobName != null && cost > 0) {
            this.mobCostMap.put(mobName, cost);
        }
    }

    public String createWootName(EntityLiving entityLiving) {
        String name = EntityList.func_75621_b((Entity)entityLiving);
        name = entityLiving instanceof EntitySkeleton ? (((EntitySkeleton)entityLiving).func_189771_df() == SkeletonType.WITHER ? "wither:" + name : "none:" + name) : "none:" + name;
        return "Woot:" + name;
    }

    public String createWootName(String name) {
        return "Woot:" + name;
    }

    private String createDisplayName(EntityLiving entityLiving) {
        if (entityLiving instanceof EntitySkeleton) {
            if (((EntitySkeleton)entityLiving).func_189771_df() == SkeletonType.WITHER) {
                return StringHelper.localize("entity.Woot:witherskelly.name");
            }
            return entityLiving.func_70005_c_();
        }
        return entityLiving.func_70005_c_();
    }

    public boolean isPrismValid(String wootName) {
        if (this.isEnderDragon(wootName)) {
            return false;
        }
        String[] mobList = Settings.usePrismWhitelist ? Settings.prismWhitelist : Settings.prismBlacklist;
        for (int i = 0; i < mobList.length; ++i) {
            if (!mobList[i].equals(wootName)) continue;
            return mobList == Settings.prismWhitelist;
        }
        return mobList == Settings.prismBlacklist;
    }

    public void cmdDumpPrism(ICommandSender sender) {
        if (Settings.usePrismWhitelist) {
            for (int i = 0; i < Settings.prismWhitelist.length; ++i) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.Woot:woot.dump.prism.whitelist.summary", new Object[]{Settings.prismWhitelist[i]}));
            }
        } else {
            for (int i = 0; i < Settings.prismBlacklist.length; ++i) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.Woot:woot.dump.prism.blacklist.summary", new Object[]{Settings.prismBlacklist[i]}));
            }
        }
    }

    public void cmdDumpCosts(ICommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (String name : this.mobCostMap.keySet()) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.Woot:woot.cost.summary", new Object[]{name, this.mobCostMap.get(name)}));
        }
    }

    public String onEntityLiving(EntityLiving entityLiving) {
        String name = EntityList.func_75621_b((Entity)entityLiving);
        String wootName = this.createWootName(entityLiving);
        String displayName = this.createDisplayName(entityLiving);
        if (!this.mobInfoHashMap.containsKey(wootName)) {
            MobInfo info = new MobInfo(wootName, displayName);
            this.mobInfoHashMap.put(wootName, info);
        } else {
            MobInfo mobInfo = this.mobInfoHashMap.get(wootName);
            if (mobInfo.displayName.equals(INVALID_MOB_NAME)) {
                mobInfo.displayName = displayName;
            }
        }
        return wootName;
    }

    public void addMapping(String wootName, int xp) {
        if (!this.mobInfoHashMap.containsKey(wootName)) {
            MobInfo info = new MobInfo(wootName, xp);
            this.mobInfoHashMap.put(wootName, info);
        } else {
            this.mobInfoHashMap.get(wootName).setXp(xp);
        }
    }

    public boolean isKnown(String wootName) {
        return this.mobInfoHashMap.containsKey(wootName);
    }

    void extraEntitySetup(MobInfo mobInfo, Entity entity) {
        if (this.isWitherSkeleton(mobInfo.wootMobName, entity)) {
            ((EntitySkeleton)entity).func_189768_a(SkeletonType.WITHER);
        } else if (this.isSlime(mobInfo.wootMobName, entity)) {
            if (((EntitySlime)entity).func_70809_q() != 1) {
                this.setSlimeSize((EntitySlime)entity, 1);
            }
        } else if (this.isMagmaCube(mobInfo.wootMobName, entity) && ((EntitySlime)entity).func_70809_q() == 1) {
            this.setSlimeSize((EntitySlime)entity, 2);
        }
    }

    private void setSlimeSize(EntitySlime entitySlime, int size) {
        String[] methodNames = new String[]{"func_70799_a", "setSlimeSize"};
        try {
            Method m = ReflectionHelper.findMethod(EntitySlime.class, null, (String[])methodNames, (Class[])new Class[]{Integer.TYPE});
            m.invoke((Object)entitySlime, size);
        }
        catch (Throwable e) {
            LogHelper.warn("Reflection EntitySlime.setSlimeSize failed");
        }
    }

    boolean isEnderDragon(String wootName) {
        return ENDER_DRAGON.equals(wootName);
    }

    boolean isWitherSkeleton(String wootName, Entity entity) {
        return entity instanceof EntitySkeleton && wootName.equals("Woot:wither:Skeleton");
    }

    boolean isSlime(String wootName, Entity entity) {
        return entity instanceof EntitySlime && wootName.equals("Woot:none:Slime");
    }

    boolean isMagmaCube(String wootName, Entity entity) {
        return entity instanceof EntityMagmaCube && wootName.equals("Woot:none:LavaSlime");
    }

    public Entity createEntity(String wootName, World world) {
        Entity entity;
        if (!this.isKnown(wootName)) {
            this.addMapping(wootName, -1);
        }
        if ((entity = EntityList.func_75620_a((String)this.mobInfoHashMap.get(wootName).getMcMobName(), (World)world)) != null) {
            this.extraEntitySetup(this.mobInfoHashMap.get(wootName), entity);
        }
        return entity;
    }

    public boolean hasXp(String wootName) {
        return this.mobInfoHashMap.containsKey(wootName) && this.mobInfoHashMap.get(wootName).hasXp();
    }

    public int getSpawnXp(String wootName) {
        Integer cost = Woot.mobRegistry.mobCostMap.get(wootName);
        if (cost != null) {
            return cost;
        }
        if (this.mobInfoHashMap.containsKey(wootName)) {
            return this.mobInfoHashMap.get(wootName).getDeathXp();
        }
        return 1;
    }

    public int getDeathXp(String wootName) {
        if (this.mobInfoHashMap.containsKey(wootName)) {
            return this.mobInfoHashMap.get(wootName).getDeathXp();
        }
        return 1;
    }

    public String getDisplayName(String wootName) {
        if (this.mobInfoHashMap.containsKey(wootName)) {
            return this.mobInfoHashMap.get(wootName).getDisplayName();
        }
        return INVALID_MOB_NAME;
    }

    public class MobInfo {
        public static final int MIN_XP_VALUE = 1;
        String wootMobName;
        String mcMobName;
        String displayName;
        int deathXp;

        private MobInfo() {
        }

        public MobInfo(String wootMobName, int mobXp) {
            this(wootMobName, MobRegistry.INVALID_MOB_NAME, mobXp);
        }

        public MobInfo(String wootMobName, String displayName) {
            this(wootMobName, displayName, -1);
        }

        public MobInfo(String wootMobName, String displayName, int mobXp) {
            this.wootMobName = wootMobName;
            this.mcMobName = MobRegistry.getMcName(wootMobName);
            this.displayName = displayName;
            this.setXp(mobXp);
        }

        public String getMcMobName() {
            return this.mcMobName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getDeathXp() {
            return this.deathXp;
        }

        public boolean hasXp() {
            return this.deathXp != -1;
        }

        public void setXp(int mobXp) {
            this.deathXp = mobXp == 0 ? 1 : mobXp;
        }
    }
}

