/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager;

import ipsis.Woot;
import ipsis.woot.manager.EnumSpawnerUpgrade;
import ipsis.woot.manager.SpawnerUpgrade;
import ipsis.woot.manager.UpgradeManager;
import java.util.HashMap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class HeadRegistry {
    HashMap<String, HeadConfig> headConfigHashMap = new HashMap();

    public void init() {
        this.initVanilla();
        this.initModded();
    }

    void initVanilla() {
        String key = Woot.mobRegistry.createWootName("none:Skeleton");
        this.headConfigHashMap.put(key, new HeadConfig(key, new ItemStack(Items.field_151144_bL, 1, 0)));
        key = Woot.mobRegistry.createWootName("wither:Skeleton");
        this.headConfigHashMap.put(key, new HeadConfig(key, new ItemStack(Items.field_151144_bL, 1, 1)));
        key = Woot.mobRegistry.createWootName("none:Zombie");
        this.headConfigHashMap.put(key, new HeadConfig(key, new ItemStack(Items.field_151144_bL, 1, 2)));
        key = Woot.mobRegistry.createWootName("none:Creeper");
        this.headConfigHashMap.put(key, new HeadConfig(key, new ItemStack(Items.field_151144_bL, 1, 4)));
    }

    void initModded() {
        Item i = Item.func_111206_d((String)"EnderIO:blockEndermanSkull");
        if (i != null) {
            String key = Woot.mobRegistry.createWootName("none:Enderman");
            this.headConfigHashMap.put(key, new HeadConfig(key, new ItemStack(i)));
        }
    }

    public ItemStack handleDecap(String wootMobName, EnumSpawnerUpgrade upgrade) {
        SpawnerUpgrade u = UpgradeManager.getSpawnerUpgrade(upgrade);
        if (!u.isDecapitate()) {
            return null;
        }
        HeadConfig headConfig = this.headConfigHashMap.get(wootMobName);
        if (headConfig == null) {
            return null;
        }
        float chance = (float)u.getDecapitateChance() / 100.0f;
        if (Woot.RANDOM.nextFloat() <= chance) {
            return ItemStack.func_77944_b((ItemStack)headConfig.headStack);
        }
        return null;
    }

    class HeadConfig {
        String wootMobName;
        ItemStack headStack;

        public HeadConfig(String wootMobName, ItemStack headStack) {
            this.wootMobName = wootMobName;
            this.headStack = headStack.func_77946_l();
        }
    }
}

