/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.item;

import ipsis.Woot;
import ipsis.woot.init.ModItems;
import ipsis.woot.item.ItemWoot;
import ipsis.woot.oss.client.ModelHelper;
import ipsis.woot.reference.Reference;
import ipsis.woot.tileentity.TileEntityMobFactoryController;
import ipsis.woot.tileentity.multiblock.EnumMobFactoryTier;
import ipsis.woot.util.StringHelper;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPrism
extends ItemWoot {
    public static final String BASENAME = "prism";
    static final String NBT_MOBNAME = "mobName";
    static final String NBT_DISPLAYNAME = "displayName";
    static final String NBT_XP_VALUE = "mobXpCost";

    public ItemPrism() {
        super(BASENAME);
        this.func_77625_d(1);
        this.setRegistryName(Reference.MOD_ID_LOWER, BASENAME);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelHelper.registerItem(ModItems.itemPrism, BASENAME);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker.field_70170_p.field_72995_K) {
            return false;
        }
        if (!(attacker instanceof EntityPlayer)) {
            return false;
        }
        if (ItemPrism.hasMobName(stack)) {
            return false;
        }
        String wootName = Woot.mobRegistry.onEntityLiving((EntityLiving)target);
        if (!Woot.mobRegistry.isValidMobName(wootName)) {
            return false;
        }
        String displayName = Woot.mobRegistry.getDisplayName(wootName);
        if (!Woot.mobRegistry.isPrismValid(wootName)) {
            ((EntityPlayer)attacker).func_146105_b((ITextComponent)new TextComponentString(String.format(StringHelper.localize("chat.Woot:prism.invalid"), displayName, wootName)));
            return false;
        }
        ItemPrism.setMobName(stack, wootName, displayName, ((EntityLiving)target).field_70728_aV);
        ((EntityPlayer)attacker).func_146105_b((ITextComponent)new TextComponentString(String.format(StringHelper.localize("chat.Woot:prism.program"), displayName, wootName)));
        return true;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!ItemPrism.hasMobName(stack)) {
            return EnumActionResult.FAIL;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityMobFactoryController && !Woot.mobRegistry.isValidMobName(((TileEntityMobFactoryController)te).getMobName())) {
            ((TileEntityMobFactoryController)te).setMobName(ItemPrism.getMobName(stack), ItemPrism.getDisplayName(stack), ItemPrism.getXp(stack));
            if (!playerIn.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static void setMobName(ItemStack itemStack, String mobName, String displayName, int xp) {
        if (xp <= 0) {
            xp = 1;
        }
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74778_a(NBT_MOBNAME, mobName);
        itemStack.func_77978_p().func_74778_a(NBT_DISPLAYNAME, displayName);
        itemStack.func_77978_p().func_74768_a(NBT_XP_VALUE, xp);
    }

    public static String getMobName(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            return "";
        }
        return itemStack.func_77978_p().func_74779_i(NBT_MOBNAME);
    }

    public static String getDisplayName(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            return "";
        }
        return itemStack.func_77978_p().func_74779_i(NBT_DISPLAYNAME);
    }

    public static int getXp(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            return 1;
        }
        return itemStack.func_77978_p().func_74762_e(NBT_XP_VALUE);
    }

    static boolean hasMobName(ItemStack itemStack) {
        if (itemStack.func_77973_b() != ModItems.itemPrism) {
            return false;
        }
        return Woot.mobRegistry.isValidMobName(ItemPrism.getMobName(itemStack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(StringHelper.localize("tooltip.Woot:prism.0"));
        tooltip.add(StringHelper.localize("tooltip.Woot:prism.1"));
        if (stack != null && ItemPrism.hasMobName(stack) && Woot.mobRegistry.isValidMobName(ItemPrism.getMobName(stack))) {
            String displayName = ItemPrism.getDisplayName(stack);
            if (!displayName.equals("")) {
                tooltip.add(TextFormatting.GREEN + String.format("Mob: %s", StringHelper.localize(displayName)));
            }
            int xp = Woot.mobRegistry.getSpawnXp(ItemPrism.getMobName(stack));
            EnumMobFactoryTier t = Woot.tierMapper.getTierForEntity(ItemPrism.getMobName(stack), xp);
            tooltip.add(TextFormatting.BLUE + t.getTranslated("waila.Woot:factory.tier"));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemPrism.hasMobName(stack);
    }

    public static ItemStack getItemStack(String wootName, int xp) {
        if (!Woot.mobRegistry.isValidMobName(wootName)) {
            return null;
        }
        ItemStack itemStack = new ItemStack((Item)ModItems.itemPrism);
        ItemPrism.setMobName(itemStack, wootName, wootName, xp);
        return itemStack;
    }
}

