/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.block;

import ipsis.Woot;
import ipsis.woot.block.BlockWoot;
import ipsis.woot.init.ModBlocks;
import ipsis.woot.oss.client.ModelHelper;
import ipsis.woot.plugins.top.ITOPInfoProvider;
import ipsis.woot.reference.Reference;
import ipsis.woot.tileentity.TileEntityMobFactory;
import ipsis.woot.tileentity.TileEntityMobFactoryController;
import ipsis.woot.tileentity.multiblock.EnumMobFactoryTier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMobFactoryController
extends BlockWoot
implements ITileEntityProvider,
ITOPInfoProvider {
    public static final String BASENAME = "controller";

    public BlockMobFactoryController() {
        super(Material.field_151576_e, BASENAME);
        this.setRegistryName(Reference.MOD_ID_LOWER, BASENAME);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMobFactoryController();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelHelper.registerBlock(ModBlocks.blockController, BASENAME);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityMobFactoryController te = (TileEntityMobFactoryController)worldIn.func_175625_s(pos);
        te.blockAdded();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityMobFactoryController && stack != null && stack.func_77942_o()) {
            ((TileEntityMobFactoryController)te).readControllerFromNBT(stack.func_77978_p());
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityMobFactoryController) {
            TileEntityMobFactoryController tec = (TileEntityMobFactoryController)te;
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            ret.add(tec.getDroppedItemStack());
            return ret;
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        IBlockState iBlockState = world.func_180495_p(pos);
        this.func_176206_d(world, pos, iBlockState);
        if (willHarvest) {
            ItemStack itemstack1 = player.func_184614_ca();
            ItemStack itemstack2 = itemstack1 == null ? null : itemstack1.func_77946_l();
            this.func_180657_a(world, player, pos, iBlockState, world.func_175625_s(pos), itemstack2);
        }
        world.func_175698_g(pos);
        return false;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntityMobFactoryController controllerTE;
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TileEntityMobFactoryController && !(controllerTE = (TileEntityMobFactoryController)te).getModDisplayName().equals("")) {
            EnumMobFactoryTier t = Woot.tierMapper.getTierForEntity(controllerTE.getMobName(), controllerTE.getXpValue());
            probeInfo.text(TextFormatting.GREEN + controllerTE.getModDisplayName());
            probeInfo.text(TextFormatting.BLUE + String.format(t.getTranslated("waila.Woot:controller.tier"), new Object[0]));
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            BlockPos factoryPos = pos.func_177967_a(EnumFacing.DOWN, 1);
            boolean isController = worldIn.func_175625_s(pos) instanceof TileEntityMobFactoryController;
            boolean isFactory = worldIn.func_175625_s(factoryPos) instanceof TileEntityMobFactory;
            if (isController && isFactory) {
                return worldIn.func_180495_p(factoryPos).func_177230_c().func_180639_a(worldIn, factoryPos, worldIn.func_180495_p(factoryPos), playerIn, hand, heldItem, side, hitX, hitY, hitZ);
            }
        }
        return true;
    }
}

