/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.java;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.handlers.IHandler;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class HandleFloatArray
implements IHandler<float[]> {
    @Override
    public boolean canHandle(Class<?> clazz) {
        return float[].class.isAssignableFrom(clazz);
    }

    @Override
    public boolean store(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound nbt, @Nonnull String name, @Nonnull float[] object) throws IllegalArgumentException, IllegalAccessException {
        int len = 0;
        for (int i = object.length; i > 0; --i) {
            if (object[i - 1] == 0.0f) continue;
            len = i;
            break;
        }
        int[] tmp = new int[len];
        for (int i = 0; i < len; ++i) {
            tmp[i] = Float.floatToIntBits(object[i]);
        }
        nbt.func_74783_a(name, tmp);
        return true;
    }

    @Override
    public float[] read(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound nbt, @Nonnull String name, @Nullable float[] object) {
        if (nbt.func_74764_b(name) && object != null) {
            int[] tmp = nbt.func_74759_k(name);
            for (int i = 0; i < object.length; ++i) {
                object[i] = i < tmp.length ? Float.intBitsToFloat(tmp[i]) : 0.0f;
            }
        }
        return object;
    }
}

