/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.internal;

import crazypants.util.NullHelper;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.engine.StorableEngine;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class HandleStorable<T>
implements IHandler<T> {
    @Override
    public boolean canHandle(Class<?> clazz) {
        Storable annotation = clazz.getAnnotation(Storable.class);
        return annotation != null && annotation.handler() == this.getClass();
    }

    @Override
    public boolean store(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound nbt, @Nonnull String name, @Nonnull T object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        NBTTagCompound tag = new NBTTagCompound();
        StorableEngine.store(registry, phase, tag, object);
        nbt.func_74782_a(name, (NBTBase)tag);
        return true;
    }

    @Override
    public T read(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound nbt, @Nonnull String name, @Nullable T object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name) && object != null) {
            NBTTagCompound tag = NullHelper.notnullM(nbt.func_74775_l(name), "NBTTagCompound.getCompoundTag()");
            StorableEngine.read(registry, phase, tag, object);
        }
        return object;
    }
}

