/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class Things {
    private static final Map<String, IThing> aliases = new HashMap<String, IThing>();
    public static final Things TRAVEL_BLACKLIST = new Things(Config.travelStaffBlinkBlackList);
    private static final List<Things> values = new ArrayList<Things>();
    private static boolean inPreInit = true;
    private final List<IThing> things = new ArrayList<IThing>();
    private List<Item> itemList = null;
    private List<ItemStack> itemStackListRaw = null;
    private List<ItemStack> itemStackList = null;
    private List<Block> blockList = null;

    public Things(String ... names) {
        for (String string : names) {
            this.add(string);
        }
        if (inPreInit) {
            values.add(this);
        }
    }

    public static void enterInit() {
        inPreInit = false;
        for (Things element : values) {
            element.bake();
        }
        values.clear();
    }

    public Things add(Item item) {
        if (item != null) {
            this.add(new ItemThing(item));
        }
        return this;
    }

    public Things add(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() != null) {
            this.add(new ItemStackThing(itemStack));
        }
        return this;
    }

    public Things add(Block block) {
        if (block != null) {
            this.add(new BlockThing(block));
        }
        return this;
    }

    public Things add(String name) {
        this.add(new StringThing(name));
        return this;
    }

    public static void addAlias(String name, String value) {
        aliases.put(name, new StringThing(value));
    }

    public Things add(ResourceLocation resourceLocation) {
        this.add(new ResourceThing(resourceLocation));
        return this;
    }

    public Things addOredict(String name) {
        this.add(new OreThing(name));
        return this;
    }

    public Things add(Things otherThings) {
        for (IThing thing : otherThings.things) {
            this.add(thing);
        }
        return this;
    }

    private void add(IThing thing) {
        if (!inPreInit) {
            thing = thing.bake();
        }
        if (thing != null) {
            this.things.add(thing);
            this.itemList = null;
            this.itemStackListRaw = null;
            this.itemStackList = null;
            this.blockList = null;
        }
    }

    private void bake() {
        for (int i = 0; i < this.things.size(); ++i) {
            IThing thing = this.things.get(i);
            IThing bakedThing = thing.bake();
            if (bakedThing != null) {
                this.things.set(i, bakedThing);
                continue;
            }
            this.things.remove(i);
            --i;
        }
    }

    public boolean contains(Item item) {
        for (IThing thing : this.things) {
            if (!thing.is(item)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ItemStack itemStack) {
        for (IThing thing : this.things) {
            if (!thing.is(itemStack)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Block block) {
        for (IThing thing : this.things) {
            if (!thing.is(block)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.things.isEmpty();
    }

    public List<Item> getItems() {
        if (this.itemList == null) {
            this.itemList = new ArrayList<Item>();
            for (IThing thing : this.things) {
                List<Item> items = thing.getItems();
                if (items == null || items.isEmpty()) continue;
                this.itemList.addAll(items);
            }
        }
        return this.itemList;
    }

    public List<ItemStack> getItemStacksRaw() {
        if (this.itemStackListRaw == null) {
            this.itemStackListRaw = new ArrayList<ItemStack>();
            for (IThing thing : this.things) {
                List<ItemStack> itemStacks = thing.getItemStacks();
                if (itemStacks == null || itemStacks.isEmpty()) continue;
                this.itemStackListRaw.addAll(itemStacks);
            }
        }
        return this.itemStackListRaw;
    }

    public List<ItemStack> getItemStacks() {
        if (this.itemStackList == null) {
            this.itemStackList = new ArrayList<ItemStack>();
            for (ItemStack stack : this.getItemStacksRaw()) {
                if (stack == null || stack.func_77973_b() == null) continue;
                if (stack.func_77952_i() == Short.MAX_VALUE) {
                    EnderIO.proxy.getSubItems(stack.func_77973_b(), EnderIO.proxy.getCreativeTab(stack), this.itemStackList);
                    continue;
                }
                this.itemStackList.add(stack);
            }
        }
        return this.itemStackList;
    }

    public List<Block> getBlocks() {
        if (this.blockList == null) {
            this.blockList = new ArrayList<Block>();
            for (IThing thing : this.things) {
                List<Block> blocks = thing.getBlocks();
                if (blocks == null || blocks.isEmpty()) continue;
                this.blockList.addAll(thing.getBlocks());
            }
        }
        return this.blockList;
    }

    public List<Object> getRecipeObjects() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (IThing thing : this.things) {
            Object recipeObject = thing.getRecipeObject();
            if (recipeObject == null) continue;
            result.add(recipeObject);
        }
        return result;
    }

    private static class ResourceThing
    implements IThing {
        private final ResourceLocation resourceLocation;

        private ResourceThing(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        @Override
        public IThing bake() {
            if (this.resourceLocation == null) {
                return null;
            }
            if (Block.field_149771_c.func_148741_d((Object)this.resourceLocation)) {
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)this.resourceLocation);
                return new BlockThing(block).bake();
            }
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)this.resourceLocation);
            if (item != null) {
                return new ItemThing(item).bake();
            }
            return null;
        }

        @Override
        public boolean is(Item item) {
            return false;
        }

        @Override
        public boolean is(ItemStack itemStack) {
            return false;
        }

        @Override
        public boolean is(Block block) {
            return false;
        }

        @Override
        public List<Item> getItems() {
            return Collections.emptyList();
        }

        @Override
        public List<ItemStack> getItemStacks() {
            return Collections.emptyList();
        }

        @Override
        public List<Block> getBlocks() {
            return Collections.emptyList();
        }

        @Override
        public Object getRecipeObject() {
            return null;
        }
    }

    private static class StringThing
    implements IThing {
        private final String name;

        private StringThing(String name) {
            this.name = name;
        }

        @Override
        public IThing bake() {
            String[] split;
            if (this.name == null || this.name.trim().isEmpty()) {
                return null;
            }
            if (aliases.containsKey(this.name)) {
                return ((IThing)aliases.get(this.name)).bake();
            }
            String mod = "minecraft";
            String ident = this.name;
            boolean allowItem = true;
            boolean allowBlock = true;
            boolean allowOreDict = true;
            if (ident.startsWith("item:")) {
                allowOreDict = false;
                allowBlock = false;
                ident = ident.substring("item:".length());
            } else if (ident.startsWith("block:")) {
                allowOreDict = false;
                allowItem = false;
                ident = ident.substring("block:".length());
            } else if (ident.startsWith("oredict:")) {
                allowItem = false;
                allowBlock = false;
                ident = ident.substring("oredict:".length());
            }
            int meta = -1;
            if (ident.contains(":") && (split = ident.split(":", 3)) != null && split.length >= 2) {
                mod = split[0];
                ident = split[1];
                if (split.length >= 3) {
                    if ("*".equals(split[2])) {
                        meta = Short.MAX_VALUE;
                    } else {
                        try {
                            meta = Integer.parseInt(split[2]);
                        }
                        catch (NumberFormatException e) {
                            return null;
                        }
                    }
                }
            }
            ResourceLocation resourceLocation = new ResourceLocation(mod, ident);
            if (meta < 0) {
                Item item;
                if (allowBlock && Block.field_149771_c.func_148741_d((Object)resourceLocation)) {
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
                    return new BlockThing(block).bake();
                }
                if (allowItem && Item.field_150901_e.func_148741_d((Object)resourceLocation) && (item = (Item)Item.field_150901_e.func_82594_a((Object)resourceLocation)) != null) {
                    return new ItemThing(item).bake();
                }
                if (allowOreDict) {
                    return new OreThing(ident).bake();
                }
            } else {
                Item item;
                if (allowItem && Item.field_150901_e.func_148741_d((Object)resourceLocation) && (item = (Item)Item.field_150901_e.func_82594_a((Object)resourceLocation)) != null) {
                    return new ItemStackThing(new ItemStack(item, 1, meta)).bake();
                }
                if (allowBlock && Block.field_149771_c.func_148741_d((Object)resourceLocation)) {
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
                    return new ItemStackThing(new ItemStack(block, 1, meta)).bake();
                }
            }
            return null;
        }

        @Override
        public boolean is(Item item) {
            return false;
        }

        @Override
        public boolean is(ItemStack itemStack) {
            return false;
        }

        @Override
        public boolean is(Block block) {
            return false;
        }

        @Override
        public List<Item> getItems() {
            return Collections.emptyList();
        }

        @Override
        public List<ItemStack> getItemStacks() {
            return Collections.emptyList();
        }

        @Override
        public List<Block> getBlocks() {
            return Collections.emptyList();
        }

        @Override
        public Object getRecipeObject() {
            return null;
        }
    }

    private static class OreThing
    implements IThing {
        private final String name;
        private List<ItemStack> ores;

        private OreThing(String name) {
            this.name = name;
        }

        @Override
        public IThing bake() {
            if (OreDictionary.doesOreNameExist((String)this.name)) {
                this.ores = OreDictionary.getOres((String)this.name);
                if (!this.ores.isEmpty()) {
                    return this;
                }
            }
            return null;
        }

        @Override
        public boolean is(Item item) {
            for (ItemStack oreStack : this.ores) {
                if (oreStack == null || oreStack.func_77973_b() != item) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean is(ItemStack itemStack) {
            for (ItemStack oreStack : this.ores) {
                if (itemStack == null || oreStack == null || itemStack.func_77973_b() != oreStack.func_77973_b() || oreStack.func_77981_g() && oreStack.func_77952_i() != Short.MAX_VALUE && oreStack.func_77960_j() != itemStack.func_77960_j()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean is(Block block) {
            for (ItemStack oreStack : this.ores) {
                if (oreStack == null || Item.func_150898_a((Block)block) != oreStack.func_77973_b() && Block.func_149634_a((Item)oreStack.func_77973_b()) != block) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<Item> getItems() {
            ArrayList<Item> result = new ArrayList<Item>();
            for (ItemStack itemStack : this.ores) {
                if (itemStack == null || itemStack.func_77973_b() == null || result.contains(itemStack.func_77973_b())) continue;
                result.add(itemStack.func_77973_b());
            }
            return result;
        }

        @Override
        public List<ItemStack> getItemStacks() {
            return this.ores;
        }

        @Override
        public List<Block> getBlocks() {
            ArrayList<Block> result = new ArrayList<Block>();
            for (ItemStack itemStack : this.ores) {
                Block block;
                if (itemStack == null || itemStack.func_77973_b() == null || (block = Block.func_149634_a((Item)itemStack.func_77973_b())) == null || block == Blocks.field_150350_a) continue;
                result.add(block);
            }
            return result;
        }

        @Override
        public Object getRecipeObject() {
            return this.name;
        }
    }

    private static class BlockThing
    implements IThing {
        private final Block block;

        public BlockThing(Block block) {
            this.block = block;
        }

        @Override
        public IThing bake() {
            return this.block != null ? this : null;
        }

        @Override
        public boolean is(Item item) {
            return Item.func_150898_a((Block)this.block) == item || Block.func_149634_a((Item)item) == this.block;
        }

        @Override
        public boolean is(ItemStack itemStack) {
            return Item.func_150898_a((Block)this.block) == itemStack.func_77973_b() || Block.func_149634_a((Item)itemStack.func_77973_b()) == this.block;
        }

        @Override
        public boolean is(Block block) {
            return this.block == block;
        }

        @Override
        public List<Item> getItems() {
            Item item = Item.func_150898_a((Block)this.block);
            return item != null ? Collections.singletonList(item) : null;
        }

        @Override
        public List<ItemStack> getItemStacks() {
            Item item = Item.func_150898_a((Block)this.block);
            return item != null ? Collections.singletonList(new ItemStack(item)) : null;
        }

        @Override
        public List<Block> getBlocks() {
            return Collections.singletonList(this.block);
        }

        @Override
        public Object getRecipeObject() {
            return this.block;
        }
    }

    private static class ItemStackThing
    implements IThing {
        private final ItemStack itemStack;

        private ItemStackThing(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        @Override
        public IThing bake() {
            return this.itemStack != null && this.itemStack.func_77973_b() != null ? this : null;
        }

        @Override
        public boolean is(Item item) {
            return this.itemStack.func_77973_b() == item;
        }

        @Override
        public boolean is(ItemStack itemStack) {
            return itemStack != null && this.itemStack.func_77973_b() == itemStack.func_77973_b() && (!this.itemStack.func_77981_g() || this.itemStack.func_77952_i() == Short.MAX_VALUE || this.itemStack.func_77960_j() == itemStack.func_77960_j());
        }

        @Override
        public boolean is(Block block) {
            return Item.func_150898_a((Block)block) == this.itemStack.func_77973_b() || Block.func_149634_a((Item)this.itemStack.func_77973_b()) == block;
        }

        @Override
        public List<Item> getItems() {
            return Collections.singletonList(this.itemStack.func_77973_b());
        }

        @Override
        public List<ItemStack> getItemStacks() {
            return Collections.singletonList(this.itemStack);
        }

        @Override
        public List<Block> getBlocks() {
            Block block = Block.func_149634_a((Item)this.itemStack.func_77973_b());
            return block != null && block != Blocks.field_150350_a ? Collections.singletonList(block) : Collections.emptyList();
        }

        @Override
        public Object getRecipeObject() {
            return this.itemStack;
        }
    }

    private static class ItemThing
    implements IThing {
        private final Item item;

        private ItemThing(Item item) {
            this.item = item;
        }

        @Override
        public IThing bake() {
            return this.item != null ? this : null;
        }

        @Override
        public boolean is(Item item) {
            return this.item == item;
        }

        @Override
        public boolean is(ItemStack itemStack) {
            return itemStack != null && itemStack.func_77973_b() == this.item;
        }

        @Override
        public boolean is(Block block) {
            return Item.func_150898_a((Block)block) == this.item || Block.func_149634_a((Item)this.item) == block;
        }

        @Override
        public List<Item> getItems() {
            return Collections.singletonList(this.item);
        }

        @Override
        public List<ItemStack> getItemStacks() {
            return Collections.singletonList(new ItemStack(this.item));
        }

        @Override
        public List<Block> getBlocks() {
            Block block = Block.func_149634_a((Item)this.item);
            return block != null && block != Blocks.field_150350_a ? Collections.singletonList(block) : Collections.emptyList();
        }

        @Override
        public Object getRecipeObject() {
            return this.item;
        }
    }

    private static interface IThing {
        public IThing bake();

        public boolean is(Item var1);

        public boolean is(ItemStack var1);

        public boolean is(Block var1);

        public List<Item> getItems();

        public List<ItemStack> getItemStacks();

        public List<Block> getBlocks();

        public Object getRecipeObject();
    }
}

