/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.top;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.FluidUtil;
import com.google.common.base.Function;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.ContinuousTask;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.obelisk.spawn.AbstractMobObelisk;
import crazypants.enderio.machine.ranged.IRanged;
import crazypants.enderio.power.IInternalPoweredTile;
import crazypants.util.CapturedMob;
import crazypants.util.NbtValue;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class TOPCompatibility
implements Function<ITheOneProbe, Void>,
IProbeInfoProvider,
IProbeConfigProvider {
    public static ITheOneProbe probe;

    @Nullable
    public Void apply(@Nullable ITheOneProbe theOneProbe) {
        if (Config.topEnabled) {
            probe = theOneProbe;
            Log.info("Enabled support for The One Probe");
            probe.registerProvider((IProbeInfoProvider)this);
            probe.registerProbeConfigProvider((IProbeConfigProvider)this);
        } else {
            Log.info("Support for The One Probe is DISABLED by a configuration setting");
        }
        return null;
    }

    public String getID() {
        return EnderIO.DOMAIN + ":default";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData hitData) {
        TileEntity tileEntity;
        if (probeInfo != null && world != null && blockState != null && hitData != null && blockState.func_177230_c() instanceof BlockEio && (tileEntity = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)hitData.getPos())) != null) {
            EioBox eiobox = new EioBox(probeInfo);
            Data data = new Data(tileEntity, hitData);
            this.mkProgressLine(mode, eiobox, data);
            this.mkRfLine(mode, eiobox, data);
            this.mkRedstoneLine(mode, eiobox, data);
            this.mkSideConfigLine(mode, eiobox, data);
            this.mkRangeLine(mode, eiobox, data);
            this.mkTankLines(mode, eiobox, data);
            eiobox.finish();
            EioBox mobbox = new EioBox(probeInfo);
            this.mkMobsBox(mode, mobbox, world, data);
            mobbox.finish();
        }
    }

    private void mkMobsBox(ProbeMode mode, EioBox mobbox, World world, Data data) {
        if (data.hasMobs) {
            if (mode != ProbeMode.NORMAL || Config.topShowMobsByDefault) {
                mobbox.get().text(TextFormatting.YELLOW + EnderIO.lang.localize("top.action.header", new Object[]{data.mobAction}));
                if (data.mobs.isEmpty()) {
                    mobbox.get().text(TextFormatting.DARK_RED + EnderIO.lang.localize("top.action.none"));
                } else if (data.mobs.size() <= 4) {
                    for (CapturedMob capturedMob : data.mobs) {
                        mobbox.get().horizontal(mobbox.center()).entity(capturedMob.getEntity(world, false)).text(capturedMob.getDisplayName());
                    }
                } else {
                    IProbeInfo mobList = mobbox.get().horizontal(mobbox.center());
                    int count = 0;
                    for (CapturedMob capturedMob : data.mobs) {
                        if (count++ >= 4) {
                            mobList = mobbox.get().horizontal(mobbox.center());
                            count = 0;
                        }
                        mobList.entity(capturedMob.getEntity(world, false));
                    }
                }
            } else {
                mobbox.addMore();
            }
        }
    }

    private void mkRangeLine(ProbeMode mode, EioBox eiobox, Data data) {
        if (data.hasRange) {
            if (mode != ProbeMode.NORMAL || Config.topShowRangeByDefault) {
                int sizeX = (int)data.bounds.sizeX();
                int sizeY = (int)data.bounds.sizeY();
                int sizeZ = (int)data.bounds.sizeZ();
                TOPCompatibility.addIcon(eiobox.get().horizontal(eiobox.center()), IconEIO.SHOW_RANGE).text(TextFormatting.YELLOW + EnderIO.lang.localize("top.range.header", new Object[]{TextFormatting.WHITE + EnderIO.lang.localize("top.range", new Object[]{sizeX, sizeY, sizeZ})}));
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkSideConfigLine(ProbeMode mode, EioBox eiobox, Data data) {
        if (data.hasIOMode) {
            if (mode != ProbeMode.NORMAL || Config.topShowSideConfigByDefault) {
                TOPCompatibility.addIcon(eiobox.get().horizontal(eiobox.center()), IconEIO.IO_CONFIG_UP).vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(TextFormatting.YELLOW + EnderIO.lang.localize("gui.machine.side", new Object[]{TextFormatting.WHITE + EnderIO.lang.localize("gui.machine.side." + data.sideName)})).text(TextFormatting.YELLOW + EnderIO.lang.localize("gui.machine.ioMode", new Object[]{data.ioMode.colorLocalisedName()}));
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkRedstoneLine(ProbeMode mode, EioBox eiobox, Data data) {
        if (data.hasRedstone) {
            if (mode != ProbeMode.NORMAL || Config.topShowRedstoneByDefault) {
                TOPCompatibility.addIcon(eiobox.get().horizontal(eiobox.center()), data.redstoneIcon).vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(data.redstoneTooltip).text(TextFormatting.YELLOW + EnderIO.lang.localize("top.redstone.header", new Object[]{TextFormatting.WHITE + EnderIO.lang.localize("top.redstone." + data.redstoneControlStatus)}));
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkRfLine(ProbeMode mode, EioBox eiobox, Data data) {
        if (data.hasRF) {
            if (mode != ProbeMode.NORMAL || Config.topShowPowerByDefault) {
                IProbeInfo rfLine = eiobox.get().horizontal(eiobox.center()).item(new ItemStack(Items.field_151137_ax));
                if (data.isPowered) {
                    rfLine.progress(data.rf, data.maxrf, eiobox.getProbeinfo().defaultProgressStyle().suffix(EnderIO.lang.localize("top.suffix.rf")).filledColor(-2739677).alternateFilledColor(-2739677));
                } else {
                    rfLine.text(TextFormatting.DARK_RED + EnderIO.lang.localize("top.machine.outofpower"));
                }
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkTankLines(ProbeMode mode, EioBox eiobox, Data data) {
        if (data.tankData != null && !data.tankData.isEmpty()) {
            if (mode != ProbeMode.NORMAL || Config.topShowTanksByDefault) {
                for (ITankAccess.ITankData tank : data.tankData) {
                    ItemStack stack = new ItemStack((Block)EnderIO.blockTank);
                    String content1 = null;
                    String content2 = null;
                    FluidStack fluid = tank.getContent();
                    if (fluid != null) {
                        FluidStack fluid2 = fluid.copy();
                        fluid2.amount = fluid.amount * 16000 / tank.getCapacity();
                        FluidUtil.FluidAndStackResult fillContainer = FluidUtil.tryFillContainer((ItemStack)stack, (FluidStack)fluid2);
                        if (fillContainer.result.itemStack != null) {
                            stack = fillContainer.result.itemStack;
                            NbtValue.FAKE.setInt(stack, 1);
                        }
                        content1 = fluid.getLocalizedName();
                        content2 = EnderIO.lang.localize("top.tank.content", new Object[]{fluid.amount, tank.getCapacity()});
                    } else {
                        content1 = EnderIO.lang.localize("top.tank.content.empty");
                        content2 = EnderIO.lang.localize("top.tank.content", new Object[]{0, tank.getCapacity()});
                    }
                    switch (tank.getTankType()) {
                        case INPUT: {
                            content1 = TextFormatting.YELLOW + EnderIO.lang.localize("top.tank.header.input", new Object[]{TextFormatting.WHITE + content1});
                            break;
                        }
                        case OUTPUT: {
                            content1 = TextFormatting.YELLOW + EnderIO.lang.localize("top.tank.header.output", new Object[]{TextFormatting.WHITE + content1});
                            break;
                        }
                        case STORAGE: {
                            content1 = TextFormatting.YELLOW + EnderIO.lang.localize("top.tank.header.storage", new Object[]{TextFormatting.WHITE + content1});
                        }
                    }
                    eiobox.get().horizontal(eiobox.center()).item(stack).vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(content1).text(content2);
                }
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkProgressLine(ProbeMode mode, EioBox eiobox, Data data) {
        if (data.progressResult != Data.ProgressResult.NONE) {
            if (mode != ProbeMode.NORMAL || Config.topShowProgressByDefault || data.progressResult == Data.ProgressResult.PROGRESS_NO_POWER) {
                IProbeInfo progressLine = eiobox.get().horizontal(eiobox.center()).item(new ItemStack(Items.field_151113_aN));
                switch (data.progressResult) {
                    case PROGRESS: {
                        progressLine.progress((int)(data.progress * 100.0f), 100, eiobox.getProbeinfo().defaultProgressStyle().suffix(EnderIO.lang.localize("top.suffix.percent")).filledColor(-18944).alternateFilledColor(-18944));
                        break;
                    }
                    case PROGRESS_NO_POWER: {
                        progressLine.text(TextFormatting.DARK_RED + EnderIO.lang.localize("top.progress.outofpower"));
                        break;
                    }
                    case PROGRESS_ACTIVE: 
                    case NO_PROGRESS_ACTIVE: {
                        progressLine.text(EnderIO.lang.localize("top.machine.active"));
                        break;
                    }
                    case PROGRESS_IDLE: 
                    case NO_PROGRESS_IDLE: {
                        progressLine.text(EnderIO.lang.localize("top.machine.idle"));
                        break;
                    }
                }
            } else {
                eiobox.addMore();
            }
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
    }

    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (config != null && blockState != null && blockState.func_177230_c() instanceof BlockEio) {
            config.setRFMode(0);
        }
    }

    private static IProbeInfo addIcon(IProbeInfo probeInfo, IWidgetIcon icon) {
        return TOPCompatibility.addIcon(probeInfo, icon, 4);
    }

    private static IProbeInfo addIcon(IProbeInfo probeInfo, IWidgetIcon icon, int border) {
        ResourceLocation texture = icon.getMap().getTexture();
        int x = icon.getX();
        int y = icon.getY();
        int width = icon.getWidth();
        int height = icon.getHeight();
        return probeInfo.icon(texture, x, y, width, height, probeInfo.defaultIconStyle().width(width + border).height(height + border));
    }

    private static class Data {
        boolean hasStatus;
        boolean hasProgress;
        boolean hasRF;
        boolean hasRedstone;
        boolean hasIOMode;
        boolean hasRange;
        boolean hasMobs;
        boolean isActive;
        boolean isPowered;
        boolean redstoneControlStatus;
        float progress;
        int rf;
        int maxrf;
        String redstoneTooltip;
        String sideName;
        String mobAction;
        IWidgetIcon redstoneIcon;
        IoMode ioMode;
        BoundingBox bounds;
        List<CapturedMob> mobs;
        ProgressResult progressResult = ProgressResult.NONE;
        List<ITankAccess.ITankData> tankData = null;

        public Data(TileEntity tileEntity, IProbeHitData hitData) {
            Object te;
            if (tileEntity instanceof AbstractMachineEntity) {
                te = (AbstractMachineEntity)tileEntity;
                this.isActive = ((AbstractMachineEntity)te).isActive();
                this.hasStatus = true;
            }
            if (tileEntity instanceof IInternalPoweredTile && (te = (IInternalPoweredTile)tileEntity).displayPower()) {
                this.maxrf = te.getMaxEnergyStored();
                this.rf = te.getEnergyStored();
                this.isPowered = this.rf > 0;
                boolean bl = this.hasRF = this.maxrf > 0;
            }
            if (tileEntity instanceof IProgressTile) {
                IProgressTile progressTile = (IProgressTile)tileEntity;
                this.progress = progressTile.getProgress();
                this.hasProgress = true;
                if (tileEntity instanceof AbstractPoweredTaskEntity) {
                    AbstractPoweredTaskEntity te2 = (AbstractPoweredTaskEntity)tileEntity;
                    if (te2.getCurrentTask() instanceof ContinuousTask) {
                        this.hasProgress = false;
                    }
                } else if (tileEntity instanceof IConduitBundle) {
                    this.hasProgress = false;
                }
            }
            if (tileEntity instanceof IRedstoneModeControlable) {
                te = (IRedstoneModeControlable)tileEntity;
                RedstoneControlMode redstoneControlMode = te.getRedstoneControlMode();
                this.redstoneControlStatus = te.getRedstoneControlStatus();
                RedstoneControlMode.IconHolder iconHolder = RedstoneControlMode.IconHolder.getFromMode(redstoneControlMode);
                this.redstoneIcon = iconHolder.getIcon();
                this.redstoneTooltip = iconHolder.getTooltip();
                this.hasRedstone = true;
            }
            if (tileEntity instanceof IIoConfigurable) {
                te = (IIoConfigurable)tileEntity;
                this.sideName = hitData.getSideHit().name().toLowerCase(Locale.US);
                this.ioMode = te.getIoMode(hitData.getSideHit());
                this.hasIOMode = true;
            }
            if (tileEntity instanceof IRanged) {
                te = (IRanged)tileEntity;
                this.bounds = te.getBounds();
                boolean bl = this.hasRange = this.bounds != null;
            }
            if (tileEntity instanceof AbstractMobObelisk) {
                te = (AbstractMobObelisk)tileEntity;
                this.mobs = ((AbstractMobObelisk)te).getMobsInFilter();
                this.mobAction = ((AbstractMobObelisk)te).getSpawnObeliskAction().getActionString();
                this.hasMobs = true;
            }
            if (tileEntity instanceof ITankAccess.IExtendedTankAccess) {
                this.tankData = ((ITankAccess.IExtendedTankAccess)tileEntity).getTankDisplayData();
            }
            this.calculateProgress();
        }

        private void calculateProgress() {
            if (this.hasProgress) {
                this.progressResult = this.progress > 0.0f ? (this.hasRF && !this.isPowered ? ProgressResult.PROGRESS_NO_POWER : ProgressResult.PROGRESS) : (this.hasStatus && this.isActive ? ProgressResult.PROGRESS_ACTIVE : ProgressResult.PROGRESS_IDLE);
            } else if (this.hasStatus) {
                this.progressResult = this.isActive ? ProgressResult.NO_PROGRESS_ACTIVE : ProgressResult.NO_PROGRESS_IDLE;
            }
        }

        static enum ProgressResult {
            NONE,
            PROGRESS,
            PROGRESS_ACTIVE,
            PROGRESS_NO_POWER,
            PROGRESS_IDLE,
            NO_PROGRESS_ACTIVE,
            NO_PROGRESS_IDLE;

        }
    }

    private static class EioBox {
        private final IProbeInfo probeinfo;
        private IProbeInfo eiobox;
        private boolean addMoreIndicator = false;

        public EioBox(IProbeInfo probeinfo) {
            this.probeinfo = probeinfo;
        }

        public IProbeInfo getProbeinfo() {
            return this.probeinfo;
        }

        public IProbeInfo get() {
            if (this.eiobox == null) {
                this.eiobox = this.probeinfo.vertical(this.probeinfo.defaultLayoutStyle().borderColor(Integer.valueOf(-65536)));
            }
            return this.eiobox;
        }

        public ILayoutStyle center() {
            return this.probeinfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
        }

        public void addMore() {
            this.addMoreIndicator = true;
        }

        public void finish() {
            if (this.eiobox != null) {
                if (this.addMoreIndicator) {
                    TOPCompatibility.addIcon(TOPCompatibility.addIcon(this.get().horizontal(this.center()), IconEIO.TOP_NOICON, 0), IconEIO.TOP_MORE, 0);
                } else {
                    TOPCompatibility.addIcon(TOPCompatibility.addIcon(this.get().horizontal(this.center()), IconEIO.TOP_NOICON, 0), IconEIO.TOP_NOMORE, 0);
                }
            } else if (this.addMoreIndicator) {
                TOPCompatibility.addIcon(TOPCompatibility.addIcon(this.probeinfo.vertical().horizontal(this.center()), IconEIO.TOP_NOICON_WIDE, 0), IconEIO.TOP_MORE, 0);
            }
        }
    }
}

