/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.common.util.BlockCoord;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.ITelePad;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.capacitor.CapacitorKeyType;
import crazypants.enderio.capacitor.DefaultCapacitorData;
import crazypants.enderio.capacitor.DefaultCapacitorKey;
import crazypants.enderio.capacitor.ICapacitorData;
import crazypants.enderio.capacitor.ICapacitorKey;
import crazypants.enderio.capacitor.Scaler;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.MachineSound;
import crazypants.enderio.machine.PacketPowerStorage;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.TeleportUtil;
import crazypants.enderio.teleport.anchor.TileTravelAnchor;
import crazypants.enderio.teleport.telepad.BlockType;
import crazypants.enderio.teleport.telepad.ITileTelePad;
import crazypants.enderio.teleport.telepad.PacketTeleport;
import crazypants.enderio.teleport.telepad.PacketUpdateCoords;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileTelePad
extends TileTravelAnchor
implements ITileTelePad {
    private ICapacitorData capacitorData = DefaultCapacitorData.BASIC_CAPACITOR;
    private final ICapacitorKey maxEnergyRecieved = new DefaultCapacitorKey(ModObject.blockTelePad, CapacitorKeyType.ENERGY_INTAKE, Scaler.Factory.POWER, 1000);
    private final ICapacitorKey maxEnergyStored = new DefaultCapacitorKey(ModObject.blockTelePad, CapacitorKeyType.ENERGY_BUFFER, Scaler.Factory.POWER, 100000);
    private final ICapacitorKey maxEnergyUsed = new DefaultCapacitorKey(ModObject.blockTelePad, CapacitorKeyType.ENERGY_USE, Scaler.Factory.POWER, 1000);
    @Store
    private int storedEnergyRF;
    private TileTelePad masterTile = null;
    private boolean coordsChanged = false;
    @Store
    private BlockCoord target = new BlockCoord();
    @Store
    private int targetDim = Integer.MIN_VALUE;
    private int lastSyncPowerStored;
    private Queue<Entity> toTeleport = Queues.newArrayDeque();
    private int powerUsed;
    private int maxPower;
    public static final ResourceLocation ACTIVE_RES = AbstractMachineEntity.getSoundFor("telepad.active");
    @SideOnly(value=Side.CLIENT)
    private MachineSound activeSound;
    @Store
    private boolean redstoneActivePrev;
    public static final String TELEPORTING_KEY = "eio:teleporting";
    public static final String PROGRESS_KEY = "teleportprogress";
    boolean wasBlocked = false;
    public float[] bladeRots = new float[3];
    public float spinSpeed = 0.0f;
    public float speedMult = 2.5f;

    @Override
    public boolean wasBlocked() {
        return this.wasBlocked;
    }

    @Override
    public void setBlocked(boolean blocked) {
        this.wasBlocked = blocked;
    }

    @Override
    public boolean isMaster() {
        return BlockType.getType(this.func_145832_p()) == BlockType.MASTER;
    }

    @Override
    public TileTelePad getMaster() {
        if (BlockType.getType(this.func_145832_p()) == BlockType.MASTER) {
            return this;
        }
        BlockPos offset = BlockType.getType(this.func_145832_p()).getOffsetToMaster();
        if (offset == null) {
            return null;
        }
        BlockPos materPos = this.func_174877_v().func_177982_a(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
        if (!this.field_145850_b.func_175667_e(materPos)) {
            return null;
        }
        TileEntity res = this.field_145850_b.func_175625_s(materPos);
        if (res instanceof TileTelePad) {
            return (TileTelePad)res;
        }
        return null;
    }

    @Override
    public boolean inNetwork() {
        return this.getMaster() != null;
    }

    public void doUpdate() {
        boolean powerChanged;
        super.doUpdate();
        if (!this.isMaster()) {
            return;
        }
        if (this.targetDim == Integer.MIN_VALUE) {
            this.targetDim = this.field_145850_b.field_73011_w.getDimension();
        }
        if (this.field_145850_b.field_72995_K) {
            this.updateEntityClient();
            return;
        }
        if (this.active()) {
            if (this.powerUsed >= this.maxPower) {
                this.teleport(this.toTeleport.poll());
                this.powerUsed = 0;
            } else {
                int usable = Math.min(Math.min(this.getUsage(), this.maxPower), this.getEnergyStored());
                this.setEnergyStored(this.getEnergyStored() - usable);
                this.powerUsed += usable;
            }
            if (this.shouldDoWorkThisTick(5)) {
                this.updateQueuedEntities();
            }
        }
        boolean bl = powerChanged = this.lastSyncPowerStored != this.getEnergyStored() && this.shouldDoWorkThisTick(5);
        if (powerChanged) {
            this.lastSyncPowerStored = this.getEnergyStored();
            PacketHandler.sendToAllAround(new PacketPowerStorage(this), (TileEntity)this);
        }
        if (this.coordsChanged) {
            this.coordsChanged = false;
            PacketHandler.sendToAllAround((IMessage)new PacketUpdateCoords(this, this.getX(), this.getY(), this.getZ(), this.getTargetDim()), (TileEntity)this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateEntityClient() {
        this.updateRotations();
        if (this.activeSound != null) {
            this.activeSound.setPitch(MathHelper.func_76131_a((float)(0.5f + this.spinSpeed / 1.5f), (float)0.5f, (float)2.0f));
        }
        if (this.active()) {
            if (this.activeSound == null) {
                BlockPos p = this.func_174877_v();
                this.activeSound = new MachineSound(ACTIVE_RES, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), 0.3f, 1.0f);
                this.playSound();
            }
            this.updateQueuedEntities();
        } else if (!this.active() && this.activeSound != null && this.activeSound.func_147655_f() <= 0.5f) {
            this.activeSound.endPlaying();
            this.activeSound = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playSound() {
        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.activeSound);
    }

    private void updateQueuedEntities() {
        if (this.field_145850_b.field_72995_K && this.active()) {
            this.getCurrentTarget().getEntityData().func_74776_a(PROGRESS_KEY, this.getProgress());
        }
        ArrayList toRemove = Lists.newArrayList();
        for (Entity e : this.toTeleport) {
            if (this.isEntityInRange(e) && !e.field_70128_L) continue;
            toRemove.add(e);
        }
        for (Entity e : toRemove) {
            this.dequeueTeleport(e, true);
        }
    }

    public void updateRedstoneState() {
        if (!this.inNetwork()) {
            return;
        }
        boolean redstone = this.isPoweredRedstone();
        if (!this.getMasterTile().redstoneActivePrev && redstone) {
            this.teleportAll();
        }
        this.getMasterTile().redstoneActivePrev = redstone;
    }

    public boolean isPainted() {
        return this.sourceBlock != null;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.stopPlayingSound();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.field_145850_b.field_72995_K) {
            this.stopPlayingSound();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopPlayingSound() {
        if (this.activeSound != null) {
            this.activeSound.endPlaying();
            this.activeSound = null;
        }
    }

    @Override
    public int getPowerScaled(int scale) {
        return (int)((float)this.getEnergyStored() / (float)this.getMaxEnergyStored() * (float)scale);
    }

    private int calculateTeleportPower() {
        if (this.field_145850_b.field_73011_w.getDimension() == this.targetDim) {
            int distance = new BlockCoord((TileEntity)this).getDist(this.target);
            double base = Math.log(0.005 * (double)distance + 1.0);
            this.maxPower = (int)(base * (double)Config.telepadPowerCoefficient);
            if (this.maxPower <= 0) {
                this.maxPower = 1;
            }
        } else {
            this.maxPower = Config.telepadPowerInterdimensional;
        }
        return this.maxPower;
    }

    public boolean active() {
        return !this.toTeleport.isEmpty();
    }

    @Override
    public Entity getCurrentTarget() {
        return this.toTeleport.peek();
    }

    public AxisAlignedBB getBoundingBox() {
        BlockPos p = this.func_174877_v();
        if (!this.inNetwork()) {
            return new AxisAlignedBB(p, p.func_177972_a(EnumFacing.UP).func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.EAST));
        }
        p = this.getMaster().getLocation().getBlockPos();
        return new AxisAlignedBB((double)(p.func_177958_n() - 1), (double)p.func_177956_o(), (double)(p.func_177952_p() - 1), (double)(p.func_177958_n() + 2), (double)(p.func_177956_o() + 1), (double)(p.func_177952_p() + 2));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getBoundingBox();
    }

    public void updateRotations() {
        this.spinSpeed = this.active() ? this.getProgress() * 2.0f : Math.max(0.0f, this.spinSpeed - 0.025f);
        int i = 0;
        while (i < this.bladeRots.length) {
            int n = i;
            this.bladeRots[n] = this.bladeRots[n] + this.spinSpeed * (float)(i * 2 + 20);
            int n2 = i++;
            this.bladeRots[n2] = this.bladeRots[n2] % 360.0f;
        }
    }

    public float getProgress() {
        return (float)this.powerUsed / (float)this.maxPower;
    }

    protected int getProgressUpdateFreq() {
        return 1;
    }

    public void setProgress(float progress) {
        this.powerUsed = progress < 0.0f ? 0 : (int)((float)this.maxPower * progress);
    }

    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public int getX() {
        if (this.inNetwork()) {
            return this.getMasterTile().target.x;
        }
        return this.target.x;
    }

    @Override
    public int getY() {
        if (this.inNetwork()) {
            return this.getMasterTile().target.y;
        }
        return this.target.y;
    }

    @Override
    public int getZ() {
        if (this.inNetwork()) {
            return this.getMasterTile().target.z;
        }
        return this.target.z;
    }

    @Override
    public int getTargetDim() {
        if (this.inNetwork()) {
            return this.getMasterTile().targetDim;
        }
        return this.targetDim;
    }

    @Override
    public ITelePad setX(int x) {
        return Config.telepadLockCoords ? null : this.setX_internal(x);
    }

    @Override
    public ITelePad setY(int y) {
        return Config.telepadLockCoords ? null : this.setY_internal(y);
    }

    @Override
    public ITelePad setZ(int z) {
        return Config.telepadLockCoords ? null : this.setZ_internal(z);
    }

    @Override
    public ITelePad setTargetDim(int dimID) {
        return Config.telepadLockDimension ? null : this.setTargetDim_internal(dimID);
    }

    @Override
    public void setCoords(BlockCoord coords) {
        if (!Config.telepadLockCoords) {
            this.setCoords_internal(coords);
        }
    }

    ITelePad setX_internal(int x) {
        if (this.inNetwork()) {
            this.setCoords(new BlockCoord(x, this.target.y, this.target.z));
            return this.getMasterTile();
        }
        return null;
    }

    ITelePad setY_internal(int y) {
        if (this.inNetwork()) {
            this.setCoords(new BlockCoord(this.target.x, y, this.target.z));
            return this.getMasterTile();
        }
        return null;
    }

    ITelePad setZ_internal(int z) {
        if (this.inNetwork()) {
            this.setCoords(new BlockCoord(this.target.x, this.target.y, z));
            return this.getMasterTile();
        }
        return null;
    }

    @Override
    public ITelePad setTargetDim_internal(int dimID) {
        if (this.inNetwork()) {
            this.getMasterTile().targetDim = dimID;
            this.coordsChanged = true;
            return this.getMasterTile();
        }
        return null;
    }

    @Override
    public void setCoords_internal(BlockCoord coords) {
        if (this.inNetwork()) {
            if (this.isMaster()) {
                this.target = coords;
                this.coordsChanged = true;
                this.func_70296_d();
            } else {
                this.getMasterTile().setCoords_internal(coords);
            }
        }
    }

    @Override
    public void teleportSpecific(Entity entity) {
        if (!this.inNetwork()) {
            return;
        }
        if (this.isMaster()) {
            if (this.isEntityInRange(entity)) {
                this.enqueueTeleport(entity, true);
            }
        } else {
            this.getMasterTile().teleportSpecific(entity);
        }
    }

    @Override
    public void teleportAll() {
        if (!this.inNetwork()) {
            return;
        }
        if (this.isMaster()) {
            for (Entity e : this.getEntitiesInRange()) {
                this.enqueueTeleport(e, true);
            }
        } else {
            this.getMasterTile().teleportAll();
        }
    }

    private List<Entity> getEntitiesInRange() {
        return this.field_145850_b.func_72872_a(Entity.class, this.getRange());
    }

    private boolean isEntityInRange(Entity entity) {
        return this.getRange().func_72318_a(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
    }

    private AxisAlignedBB getRange() {
        BlockPos p = this.func_174877_v();
        return new AxisAlignedBB((double)(p.func_177958_n() - 1), (double)p.func_177956_o(), (double)(p.func_177952_p() - 1), (double)(p.func_177958_n() + 2), (double)(p.func_177956_o() + 3), (double)(p.func_177952_p() + 2));
    }

    @Override
    public void enqueueTeleport(Entity entity, boolean sendUpdate) {
        if (entity == null || this.toTeleport.contains(entity)) {
            return;
        }
        this.calculateTeleportPower();
        entity.getEntityData().func_74757_a(TELEPORTING_KEY, true);
        this.toTeleport.add(entity);
        if (sendUpdate) {
            if (entity.field_70170_p.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTeleport(PacketTeleport.Type.BEGIN, (ITileTelePad)this, entity.func_145782_y()));
            } else {
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTeleport(PacketTeleport.Type.BEGIN, (ITileTelePad)this, entity.func_145782_y()));
            }
        }
    }

    @Override
    public void dequeueTeleport(Entity entity, boolean sendUpdate) {
        if (entity == null) {
            return;
        }
        this.toTeleport.remove(entity);
        entity.getEntityData().func_74757_a(TELEPORTING_KEY, false);
        if (sendUpdate) {
            if (this.field_145850_b.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTeleport(PacketTeleport.Type.END, (ITileTelePad)this, entity.func_145782_y()));
            } else {
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTeleport(PacketTeleport.Type.END, (ITileTelePad)this, entity.func_145782_y()));
            }
        }
        if (!this.active()) {
            this.powerUsed = 0;
        }
    }

    private boolean teleport(Entity entity) {
        if (this.maxPower > 0) {
            entity.getEntityData().func_74757_a(TELEPORTING_KEY, false);
            this.wasBlocked = !(!entity.field_70170_p.field_72995_K ? this.serverTeleport(entity) : this.clientTeleport(entity));
            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTeleport(PacketTeleport.Type.TELEPORT, (ITileTelePad)this, this.wasBlocked));
            return !this.wasBlocked;
        }
        return false;
    }

    private boolean clientTeleport(Entity entity) {
        return TeleportUtil.clientTeleport(entity, this.target.getBlockPos(), this.targetDim, TravelSource.TELEPAD);
    }

    private boolean serverTeleport(Entity entity) {
        this.dequeueTeleport(entity, true);
        return TeleportUtil.serverTeleport(entity, this.target.getBlockPos(), this.targetDim, false, TravelSource.TELEPAD);
    }

    @Override
    public boolean canSeeBlock(EntityPlayer playerName) {
        return this.isMaster() && this.inNetwork();
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        return this.inNetwork() && this.getMasterTile() != null ? (this.getMasterTile() == this ? this.maxEnergyRecieved.get(this.capacitorData) : this.getMasterTile().getMaxEnergyRecieved(dir)) : 0;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.inNetwork() && this.getMasterTile() != null ? (this.getMasterTile() == this ? this.maxEnergyStored.get(this.capacitorData) : this.getMasterTile().getMaxEnergyStored()) : 0;
    }

    @Override
    public boolean displayPower() {
        return this.inNetwork() && this.getMasterTile() != null;
    }

    @Override
    public int getEnergyStored() {
        return this.inNetwork() && this.getMasterTile() != null ? (this.getMasterTile() == this ? this.storedEnergyRF : this.getMasterTile().getEnergyStored()) : 0;
    }

    @Override
    public void setEnergyStored(int storedEnergy) {
        if (this.inNetwork() && this.getMasterTile() != null) {
            if (this.getMasterTile() == this) {
                this.storedEnergyRF = Math.min(this.getMaxEnergyStored(), storedEnergy);
            } else {
                this.getMasterTile().setEnergyStored(storedEnergy);
            }
        }
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return this.inNetwork() && this.getMasterTile() != null;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (!this.inNetwork()) {
            return 0;
        }
        int max = Math.max(0, Math.min(Math.min(this.getMaxEnergyRecieved(from), maxReceive), this.getMaxEnergyStored() - this.getEnergyStored()));
        if (!simulate) {
            this.setEnergyStored(this.getEnergyStored() + max);
        }
        return max;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.getMaxEnergyStored();
    }

    @Override
    public int getUsage() {
        return this.maxEnergyUsed.get(this.capacitorData);
    }

    private TileTelePad getMasterTile() {
        if (this.masterTile != null) {
            return this.masterTile;
        }
        this.masterTile = this.getMaster();
        return this.masterTile;
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return true;
    }
}

