/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;

public class TelepadTarget {
    private final BlockPos location;
    private final int dimension;
    private String name;
    private ItemStack icon;

    public TelepadTarget(BlockPos location, int dimension) {
        this(location, dimension, null, null);
    }

    public TelepadTarget(BlockPos location, int dimension, String name, ItemStack icon) {
        this.location = location;
        this.dimension = dimension;
        this.name = name;
        this.icon = icon;
    }

    public BlockPos getLocation() {
        return this.location;
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public void setIcon(ItemStack icon) {
        this.icon = icon;
    }

    public void writeToNBT(ItemStack printout) {
        if (printout == null) {
            return;
        }
        if (!printout.func_77942_o()) {
            printout.func_77982_d(new NBTTagCompound());
        }
        this.writeToNBT(printout.func_77978_p());
        if (this.getName() != null) {
            printout.func_151001_c(this.getName());
        } else {
            printout.func_135074_t();
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        if (this.location != null) {
            tag.func_74772_a("targetPos", this.location.func_177986_g());
        }
        tag.func_74768_a("targetDim", this.dimension);
        if (this.name != null) {
            tag.func_74778_a("targetName", this.name);
        }
        if (this.icon != null) {
            NBTTagCompound iconRoot = new NBTTagCompound();
            this.icon.func_77955_b(iconRoot);
            tag.func_74782_a("targetIcon", (NBTBase)iconRoot);
        }
    }

    public static TelepadTarget readFromNBT(ItemStack stack) {
        if (stack == null || !stack.func_77942_o()) {
            return null;
        }
        return TelepadTarget.readFromNBT(stack.func_77978_p());
    }

    public static TelepadTarget readFromNBT(NBTTagCompound tag) {
        BlockPos pos = TelepadTarget.getTargetPos(tag);
        if (pos == null) {
            return null;
        }
        return new TelepadTarget(pos, TelepadTarget.getTargetDimension(tag), TelepadTarget.getName(tag), TelepadTarget.getIcon(tag));
    }

    public static ItemStack getIcon(NBTTagCompound tag) {
        if (tag == null || !tag.func_74764_b("targetIcon")) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("targetIcon"));
    }

    public static String getName(NBTTagCompound tag) {
        if (tag == null || !tag.func_74764_b("targetName")) {
            return null;
        }
        return tag.func_74779_i("targetName");
    }

    public static BlockPos getTargetPos(NBTTagCompound tag) {
        if (tag == null || !tag.func_74764_b("targetPos")) {
            return null;
        }
        return BlockPos.func_177969_a((long)tag.func_74763_f("targetPos"));
    }

    public static int getTargetDimension(NBTTagCompound tag) {
        if (tag == null || !tag.func_74764_b("targetDim")) {
            return 0;
        }
        return tag.func_74762_e("targetDim");
    }

    public static String getDimenionName(int dim) {
        if (!DimensionManager.isDimensionRegistered((int)dim)) {
            return Integer.toString(dim);
        }
        DimensionType type = DimensionManager.getProviderType((int)dim);
        if (type == null) {
            return Integer.toString(dim);
        }
        String name = type.func_186065_b();
        int[] dims = DimensionManager.getDimensions((DimensionType)type);
        if (dims != null && dims.length > 1) {
            name = name + " " + dim;
        }
        return name;
    }
}

