/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.common.util.ItemUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUpdateLocationPrintout
implements IMessage,
IMessageHandler<PacketUpdateLocationPrintout, IMessage> {
    private ItemStack stack;
    private EntityEquipmentSlot slot;

    public PacketUpdateLocationPrintout() {
    }

    public PacketUpdateLocationPrintout(ItemStack stack, EntityEquipmentSlot slot) {
        this.stack = stack;
        this.slot = slot;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        int ord = -1;
        if (this.slot != null) {
            ord = this.slot.ordinal();
        }
        buf.writeShort(ord);
    }

    public void fromBytes(ByteBuf buf) {
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        short ord = buf.readShort();
        this.slot = ord < 0 || ord >= EntityEquipmentSlot.values().length ? null : EntityEquipmentSlot.values()[ord];
    }

    public IMessage onMessage(PacketUpdateLocationPrintout message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        ItemStack stack = message.stack;
        EntityEquipmentSlot slot = message.slot;
        if (stack == null) {
            return null;
        }
        if (slot != null) {
            player.func_184201_a(slot, stack);
            return null;
        }
        if (!ctx.getServerHandler().field_147369_b.field_71071_by.func_70441_a(stack)) {
            ItemUtil.spawnItemInWorldWithRandomMotion((World)player.field_70170_p, (ItemStack)stack, (BlockPos)player.func_180425_c());
        }
        return null;
    }
}

