/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.common.network.MessageTileEntity;
import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.EnderIO;
import crazypants.enderio.teleport.telepad.ITileTelePad;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUpdateCoords
extends MessageTileEntity<TileEntity>
implements IMessageHandler<PacketUpdateCoords, IMessage> {
    private int targetX;
    private int targetY;
    private int targetZ;
    private int targetDim;

    public PacketUpdateCoords() {
    }

    public PacketUpdateCoords(ITileTelePad te, int x, int y, int z, int targetDim) {
        super(te.getTileEntity());
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.targetDim = targetDim;
    }

    public PacketUpdateCoords(ITileTelePad te, BlockCoord bc, int targetDim) {
        this(te, bc.x, bc.y, bc.z, targetDim);
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.targetX);
        buf.writeInt(this.targetY);
        buf.writeInt(this.targetZ);
        buf.writeInt(this.targetDim);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.targetX = buf.readInt();
        this.targetY = buf.readInt();
        this.targetZ = buf.readInt();
        this.targetDim = buf.readInt();
    }

    public IMessage onMessage(PacketUpdateCoords message, MessageContext ctx) {
        TileEntity te = message.getTileEntity(ctx.side.isClient() ? EnderIO.proxy.getClientWorld() : message.getWorld(ctx));
        if (te instanceof ITileTelePad) {
            ITileTelePad tp = (ITileTelePad)te;
            tp.setCoords_internal(new BlockCoord(message.targetX, message.targetY, message.targetZ));
            tp.setTargetDim_internal(message.targetDim);
        }
        return null;
    }
}

