/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.EnderIO;
import crazypants.enderio.teleport.telepad.ITileTelePad;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTeleport
extends MessageTileEntity<TileEntity>
implements IMessageHandler<PacketTeleport, IMessage> {
    private int entityId;
    private Type type;
    private boolean wasBlocked;

    public PacketTeleport() {
    }

    public PacketTeleport(Type type, ITileTelePad te, int entityId) {
        super(te.getTileEntity());
        this.entityId = entityId;
        this.type = type;
    }

    public PacketTeleport(Type type, ITileTelePad te, boolean wasBlocked) {
        super(te.getTileEntity());
        this.wasBlocked = wasBlocked;
        this.type = type;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.entityId);
        buf.writeInt(this.type.ordinal());
        buf.writeBoolean(this.wasBlocked);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.entityId = buf.readInt();
        this.type = Type.values()[buf.readInt()];
        this.wasBlocked = buf.readBoolean();
    }

    public IMessage onMessage(PacketTeleport message, MessageContext ctx) {
        World world = ctx.side.isClient() ? EnderIO.proxy.getClientWorld() : message.getWorld(ctx);
        TileEntity te = message.getTileEntity(world);
        if (te instanceof ITileTelePad) {
            Entity e = world.func_73045_a(message.entityId);
            switch (message.type) {
                case BEGIN: {
                    ((ITileTelePad)te).enqueueTeleport(e, false);
                    break;
                }
                case END: {
                    ((ITileTelePad)te).dequeueTeleport(e, false);
                    break;
                }
                case TELEPORT: {
                    ((ITileTelePad)te).setBlocked(message.wasBlocked);
                }
            }
        }
        return null;
    }

    public static enum Type {
        BEGIN,
        END,
        TELEPORT;

    }
}

