/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.api.teleport.ITelePad;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.anchor.BlockTravelAnchor;
import crazypants.enderio.teleport.telepad.GuiLocationPrintout;
import crazypants.enderio.teleport.telepad.ITileTelePad;
import crazypants.enderio.teleport.telepad.PacketUpdateLocationPrintout;
import crazypants.enderio.teleport.telepad.TelepadTarget;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;

public class ItemLocationPrintout
extends Item
implements IGuiHandler {
    public static final String NAME = "itemLocationPrintout";

    public static ItemLocationPrintout create() {
        PacketHandler.INSTANCE.registerMessage(PacketUpdateLocationPrintout.class, PacketUpdateLocationPrintout.class, PacketHandler.nextID(), Side.SERVER);
        ItemLocationPrintout result = new ItemLocationPrintout();
        EnderIO.guiHandler.registerGuiHandler(206, result);
        EnderIO.guiHandler.registerGuiHandler(207, result);
        GameRegistry.register((IForgeRegistryEntry)result);
        return result;
    }

    protected ItemLocationPrintout() {
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(NAME);
        this.setRegistryName(NAME);
        this.func_77625_d(1);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            player.openGui((Object)EnderIO.instance, 206, world, hand.ordinal(), 0, 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof ITelePad)) {
            return EnumActionResult.PASS;
        }
        ITelePad tp = (ITelePad)te;
        ITileTelePad tile = null;
        if (te instanceof ITileTelePad) {
            tile = (ITileTelePad)te;
        }
        if (tp.canBlockBeAccessed(player)) {
            BlockPos bc = TelepadTarget.getTargetPos(stack.func_77978_p());
            if (bc == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("No location? but how.."));
                return EnumActionResult.SUCCESS;
            }
            int dim = TelepadTarget.getTargetDimension(stack.func_77978_p());
            BlockCoord cur = new BlockCoord(tp.getX(), tp.getY(), tp.getZ());
            int curDim = tp.getTargetDim();
            if (!bc.equals((Object)cur)) {
                BlockCoord portMe = new BlockCoord(bc);
                if (tile != null) {
                    tile.setCoords_internal(portMe);
                } else {
                    tp.setCoords(portMe);
                }
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("itemCoordSelector.chat.setCoords", new Object[]{portMe.chatString()})));
            }
            if (dim != curDim) {
                if (tile != null) {
                    tile.setTargetDim_internal(dim);
                } else {
                    tp.setTargetDim(dim);
                }
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("itemCoordSelector.chat.setDimension", new Object[]{TextFormatting.GREEN.toString(), TelepadTarget.getDimenionName(dim)})));
            }
            if (bc.equals((Object)cur) && dim == curDim) {
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("itemCoordSelector.chat.alreadySet")));
            }
        } else {
            BlockTravelAnchor.sendPrivateChatMessage(player, tp.getOwner());
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean p_77624_4_) {
        TelepadTarget target;
        if (stack != null && stack.func_77978_p() != null && !stack.func_77978_p().func_74767_n("default") && (target = TelepadTarget.readFromNBT(stack.func_77978_p())) != null && target.getLocation() != null) {
            list.add(new BlockCoord(target.getLocation()).chatString(TextFormatting.GRAY));
            list.add(TelepadTarget.getDimenionName(target.getDimension()));
        }
        super.func_77624_a(stack, player, list, p_77624_4_);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 207) {
            TelepadTarget target = new TelepadTarget(new BlockPos(x, y, z), world.field_73011_w.getDimension());
            ItemStack stack = new ItemStack((Item)this);
            target.writeToNBT(stack);
            return new GuiLocationPrintout(stack);
        }
        EnumHand hand = x == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        EntityEquipmentSlot slot = hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND;
        return new GuiLocationPrintout(player, slot);
    }
}

