/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public enum BlockType implements IStringSerializable
{
    SINGLE(null),
    MASTER(new BlockPos(0, 0, 0)),
    N(BlockType.reverseOffsetFor(EnumFacing.NORTH)),
    NE(BlockType.reverseOffsetFor(EnumFacing.NORTH, EnumFacing.EAST)),
    E(BlockType.reverseOffsetFor(EnumFacing.EAST)),
    SE(BlockType.reverseOffsetFor(EnumFacing.SOUTH, EnumFacing.EAST)),
    S(BlockType.reverseOffsetFor(EnumFacing.SOUTH)),
    SW(BlockType.reverseOffsetFor(EnumFacing.SOUTH, EnumFacing.WEST)),
    W(BlockType.reverseOffsetFor(EnumFacing.WEST)),
    NW(BlockType.reverseOffsetFor(EnumFacing.NORTH, EnumFacing.WEST));

    private final BlockPos offsetToMaster;

    private BlockType(BlockPos offsetToMaster) {
        this.offsetToMaster = offsetToMaster;
    }

    public BlockPos getOffsetToMaster() {
        return this.offsetToMaster;
    }

    public Vec3i getOffsetFromMaster() {
        return new BlockPos(-this.offsetToMaster.func_177958_n(), -this.offsetToMaster.func_177956_o(), -this.offsetToMaster.func_177952_p());
    }

    public BlockPos getLocationOfMaster(BlockPos loc) {
        if (this.offsetToMaster == null) {
            return null;
        }
        return loc.func_177982_a(this.offsetToMaster.func_177958_n(), this.offsetToMaster.func_177956_o(), this.offsetToMaster.func_177952_p());
    }

    public String func_176610_l() {
        return this.name().toLowerCase();
    }

    private static BlockPos reverseOffsetFor(EnumFacing ... dirs) {
        BlockPos res = new BlockPos(0, 0, 0);
        for (EnumFacing dir : dirs) {
            res = res.func_177972_a(dir.func_176734_d());
        }
        return res;
    }

    public static BlockType getType(int meta) {
        if (meta < 0 || meta >= BlockType.values().length) {
            return SINGLE;
        }
        return BlockType.values()[meta];
    }
}

