/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.packet;

import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.sound.SoundHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTravelEvent
implements IMessage,
IMessageHandler<PacketTravelEvent, IMessage> {
    int x;
    int y;
    int z;
    int powerUse;
    boolean conserveMotion;
    int entityId;
    int source;
    int hand;

    public PacketTravelEvent() {
    }

    public PacketTravelEvent(Entity entity, int x, int y, int z, int powerUse, boolean conserveMotion, TravelSource source, EnumHand hand) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.powerUse = powerUse;
        this.conserveMotion = conserveMotion;
        this.entityId = entity instanceof EntityPlayer ? -1 : entity.func_145782_y();
        this.source = source.ordinal();
        this.hand = (hand == null ? EnumHand.MAIN_HAND : hand).ordinal();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.powerUse);
        buf.writeBoolean(this.conserveMotion);
        buf.writeInt(this.entityId);
        buf.writeInt(this.source);
        buf.writeInt(this.hand);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.powerUse = buf.readInt();
        this.conserveMotion = buf.readBoolean();
        this.entityId = buf.readInt();
        this.source = buf.readInt();
        this.hand = buf.readInt();
    }

    public IMessage onMessage(PacketTravelEvent message, MessageContext ctx) {
        EntityPlayerMP toTp = message.entityId == -1 ? ctx.getServerHandler().field_147369_b : ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.entityId);
        int x1 = message.x;
        int y1 = message.y;
        int z1 = message.z;
        TravelSource source1 = TravelSource.values()[message.source];
        EnumHand hand1 = EnumHand.values()[message.hand];
        PacketTravelEvent.doServerTeleport((Entity)toTp, x1, y1, z1, message.powerUse, message.conserveMotion, source1, hand1);
        return null;
    }

    public static boolean doServerTeleport(Entity toTp, int x, int y, int z, int powerUse, boolean conserveMotion, TravelSource source, EnumHand hand) {
        EntityPlayer player = toTp instanceof EntityPlayer ? (EntityPlayer)toTp : null;
        TeleportEntityEvent evt = new TeleportEntityEvent(toTp, source, x, y, z, toTp.field_71093_bK);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return false;
        }
        x = evt.targetX;
        y = evt.targetY;
        z = evt.targetZ;
        SoundHelper.playSound(toTp.field_70170_p, toTp, source.sound, 1.0f, 1.0f);
        if (player != null) {
            player.func_70634_a((double)x + 0.5, (double)y + 1.1, (double)z + 0.5);
        } else {
            toTp.func_70107_b((double)x, (double)y, (double)z);
        }
        SoundHelper.playSound(toTp.field_70170_p, toTp, source.sound, 1.0f, 1.0f);
        toTp.field_70143_R = 0.0f;
        if (player != null) {
            ItemStack heldItem;
            if (conserveMotion) {
                Vector3d velocityVex = Util.getLookVecEio((EntityPlayer)player);
                SPacketEntityVelocity p = new SPacketEntityVelocity(toTp.func_145782_y(), velocityVex.x, velocityVex.y, velocityVex.z);
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)p);
            }
            if (powerUse > 0 && hand != null && (heldItem = player.func_184586_b(hand)) != null && heldItem.func_77973_b() instanceof IItemOfTravel) {
                ItemStack item = heldItem.func_77946_l();
                ((IItemOfTravel)item.func_77973_b()).extractInternal(item, powerUse);
                player.func_184611_a(hand, item);
            }
        }
        return true;
    }
}

