/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.anchor;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.PlayerUtil;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.paint.IPaintable;
import crazypants.util.UserIdent;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.handlers.enderio.HandleUserIdent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TileTravelAnchor
extends TileEntityEio
implements ITravelAccessable,
IPaintable.IPaintableTileEntity {
    @Store
    protected IBlockState sourceBlock;
    @Store
    private ITravelAccessable.AccessMode accessMode = ITravelAccessable.AccessMode.PUBLIC;
    @Store
    private ItemStack[] password = new ItemStack[5];
    @Store
    private ItemStack itemLabel;
    @Store
    private String label;
    @Store
    @Nonnull
    private UserIdent owner = UserIdent.nobody;
    @Store(handler=HandleUserIdent.HandleUserIdentArrayList.class)
    private List<UserIdent> authorisedUsers = new ArrayList<UserIdent>();

    @Override
    public boolean canBlockBeAccessed(EntityPlayer playerName) {
        if (this.accessMode == ITravelAccessable.AccessMode.PUBLIC) {
            return true;
        }
        return this.owner.equals(playerName.func_146103_bH()) || this.authorisedUsers.contains(playerName.func_146103_bH());
    }

    @Override
    public void clearAuthorisedUsers() {
        this.authorisedUsers.clear();
    }

    private boolean checkPassword(ItemStack[] pwd) {
        if (pwd == null || pwd.length != this.password.length) {
            return false;
        }
        for (int i = 0; i < pwd.length; ++i) {
            ItemStack pw = this.password[i];
            ItemStack tst = pwd[i];
            if (pw == null && tst != null) {
                return false;
            }
            if (pw == null || tst != null && ItemStack.func_77989_b((ItemStack)pw, (ItemStack)tst)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean getRequiresPassword(EntityPlayer playerName) {
        return this.getAccessMode() == ITravelAccessable.AccessMode.PROTECTED && !this.canUiBeAccessed(playerName) && !this.authorisedUsers.contains(PlayerUtil.getPlayerUUID((String)playerName.func_146103_bH().getName()));
    }

    @Override
    public boolean authoriseUser(EntityPlayer username, ItemStack[] passwordIn) {
        if (this.checkPassword(passwordIn)) {
            this.authorisedUsers.add(UserIdent.create(username.func_146103_bH()));
            return true;
        }
        return false;
    }

    @Override
    public boolean canUiBeAccessed(EntityPlayer playerName) {
        return this.owner.equals(playerName.func_146103_bH());
    }

    @Override
    public boolean canSeeBlock(EntityPlayer playerName) {
        if (this.accessMode != ITravelAccessable.AccessMode.PRIVATE) {
            return true;
        }
        return this.owner.equals(playerName.func_146103_bH());
    }

    @Override
    public ITravelAccessable.AccessMode getAccessMode() {
        return this.accessMode;
    }

    @Override
    public void setAccessMode(ITravelAccessable.AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    @Override
    public ItemStack[] getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(ItemStack[] password) {
        this.password = password;
    }

    @Override
    public ItemStack getItemLabel() {
        return this.itemLabel;
    }

    @Override
    public void setItemLabel(ItemStack lableIcon) {
        this.itemLabel = lableIcon;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    @Deprecated
    public UUID getPlacedBy() {
        return this.owner.getUUID();
    }

    @Override
    @Nonnull
    public UserIdent getOwner() {
        return this.owner;
    }

    @Override
    public void setPlacedBy(EntityPlayer player) {
        this.owner = player != null ? UserIdent.create(player.func_146103_bH()) : UserIdent.nobody;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return TravelSource.getMaxDistanceSq();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public IBlockState getPaintSource() {
        return this.sourceBlock;
    }

    @Override
    public void setPaintSource(@Nullable IBlockState sourceBlock) {
        this.sourceBlock = sourceBlock;
    }

    @Override
    public BlockCoord getLocation() {
        return new BlockCoord(this.field_174879_c);
    }
}

