/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.Log;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.rail.TeleporterEIO;
import crazypants.enderio.sound.SoundHelper;
import crazypants.enderio.teleport.TravelController;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TeleportUtil {
    public static boolean doTeleport(Entity entityLiving, BlockPos pos, int targetDim, boolean conserveMotion, TravelSource source) {
        if (entityLiving.field_70170_p.field_72995_K) {
            return TeleportUtil.clientTeleport(entityLiving, pos, targetDim, source);
        }
        return TeleportUtil.serverTeleport(entityLiving, pos, targetDim, conserveMotion, source);
    }

    public static boolean clientTeleport(Entity entityLiving, BlockPos pos, int targetDim, TravelSource source) {
        TeleportEntityEvent evt = new TeleportEntityEvent(entityLiving, source, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), targetDim);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return false;
        }
        if (entityLiving.field_70170_p.field_73011_w.getDimension() == targetDim) {
            return TravelController.instance.doClientTeleport(entityLiving, null, new BlockCoord(pos), source, 0, false);
        }
        return true;
    }

    public static boolean serverTeleport(Entity entity, BlockPos pos, int targetDim, boolean conserveMotion, TravelSource source) {
        TeleportEntityEvent evt = new TeleportEntityEvent(entity, source, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), targetDim);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return false;
        }
        EntityPlayerMP player = null;
        if (entity instanceof EntityPlayer) {
            player = (EntityPlayerMP)entity;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int from = entity.field_71093_bK;
        if (from != targetDim) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            WorldServer fromDim = server.func_71218_a(from);
            WorldServer toDim = server.func_71218_a(targetDim);
            TeleporterEIO teleporter = new TeleporterEIO(toDim);
            if (source != null) {
                SoundHelper.playSound((World)server.func_71218_a(entity.field_71093_bK), entity, source.sound, 1.0f, 1.0f);
            }
            if (player != null) {
                server.func_184103_al().transferPlayerToDimension(player, targetDim, (Teleporter)teleporter);
                if (from == 1 && entity.func_70089_S()) {
                    toDim.func_72838_d(entity);
                    toDim.func_72866_a(entity, false);
                }
            } else {
                NBTTagCompound tagCompound = new NBTTagCompound();
                float rotationYaw = entity.field_70177_z;
                float rotationPitch = entity.field_70125_A;
                entity.func_189511_e(tagCompound);
                Class<?> entityClass = entity.getClass();
                fromDim.func_72900_e(entity);
                try {
                    Entity newEntity = (Entity)entityClass.getConstructor(World.class).newInstance(toDim);
                    newEntity.func_70020_e(tagCompound);
                    newEntity.func_70012_b((double)x, (double)y, (double)z, rotationYaw, rotationPitch);
                    newEntity.field_98038_p = true;
                    toDim.func_72838_d(newEntity);
                    newEntity.field_98038_p = false;
                }
                catch (Exception e) {
                    Log.error("serverTeleport: Error creating a entity to be created in new dimension.");
                    return false;
                }
            }
        }
        if (player != null) {
            player.func_70634_a((double)x + 0.5, (double)y + 1.1, (double)z + 0.5);
        } else {
            entity.func_70107_b((double)x, (double)y, (double)z);
        }
        entity.field_70143_R = 0.0f;
        if (source != null) {
            SoundHelper.playSound(entity.field_70170_p, entity, source.sound, 1.0f, 1.0f);
        }
        if (player != null && conserveMotion) {
            Vector3d velocityVex = Util.getLookVecEio((EntityPlayer)player);
            SPacketEntityVelocity p = new SPacketEntityVelocity(entity.func_145782_y(), velocityVex.x, velocityVex.y, velocityVex.z);
            player.field_71135_a.func_147359_a((Packet)p);
        }
        return true;
    }
}

