/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render;

import crazypants.enderio.EnderIOTab;
import crazypants.enderio.Log;
import crazypants.enderio.conduit.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.render.EnumRenderMode;
import crazypants.enderio.render.ITintedBlock;
import crazypants.enderio.render.ITintedItem;
import crazypants.enderio.render.PaintTintHandler;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.pipeline.OverlayHolder;
import crazypants.enderio.render.pipeline.RelayingBakedModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SmartModelAttacher {
    private static final List<RegistrationHolder> blocks = new ArrayList<RegistrationHolder>();

    public static void register(Block block) {
        SmartModelAttacher.register(block, EnumRenderMode.RENDER, EnumRenderMode.DEFAULTS, EnumRenderMode.AUTO);
    }

    public static void registerNoProps(Block block) {
        SmartModelAttacher.register(block, null, null, null, false);
    }

    public static void registerItemOnly(Block block) {
        SmartModelAttacher.register(block, null, null, null, true);
    }

    public static <T extends Comparable<T>, V extends T> void register(Block block, IProperty<T> property, V defaultsValue, V autoValue) {
        SmartModelAttacher.register(block, property, defaultsValue, autoValue, false);
    }

    private static <T extends Comparable<T>, V extends T> void register(Block block, IProperty<T> property, V defaultsValue, V autoValue, boolean itemOnly) {
        blocks.add(new RegistrationHolder<T, V>(block, property, defaultsValue, autoValue, itemOnly));
    }

    public static void create() {
        MinecraftForge.EVENT_BUS.register((Object)new SmartModelAttacher());
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockItemModels() {
        for (RegistrationHolder holder : blocks) {
            Block block = holder.block;
            Item item = Item.func_150898_a((Block)block);
            if (item != null) {
                ModelResourceLocation location = new ModelResourceLocation(item.getRegistryName(), "inventory");
                if (item.func_77614_k()) {
                    ArrayList list = new ArrayList();
                    item.func_150895_a(item, EnderIOTab.tabNoTab, list);
                    for (ItemStack itemStack : list) {
                        ModelLoader.setCustomModelResourceLocation((Item)item, (int)itemStack.func_77952_i(), (ModelResourceLocation)location);
                    }
                    continue;
                }
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)location);
                continue;
            }
            Log.debug("Block " + block + " has no item, is is intended?");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerColoredBlocksAndItems() {
        ArrayList<Block> blocklist = new ArrayList<Block>();
        ArrayList<Item> itemlist = new ArrayList<Item>();
        for (RegistrationHolder holder : blocks) {
            Block block = holder.block;
            Item item = Item.func_150898_a((Block)block);
            if (block instanceof IPaintable || block instanceof ITintedBlock || block instanceof ITintedItem || item instanceof ITintedItem) {
                blocklist.add(block);
                if (item == null) continue;
                itemlist.add(item);
                continue;
            }
            if (block instanceof IBlockColor) {
                Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)block, new Block[]{block});
            }
            if (!(item instanceof IItemColor)) continue;
            Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)item, new Item[]{item});
        }
        PaintTintHandler handler = new PaintTintHandler();
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)handler, blocklist.toArray(new Block[0]));
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)handler, itemlist.toArray(new Item[0]));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void bakeModels(ModelBakeEvent event) {
        for (RegistrationHolder holder : blocks) {
            IBakedModel defaultBakedModel;
            ModelResourceLocation defaultMrl;
            IBlockState defaultState;
            Block block = holder.block;
            Map locations = new DefaultStateMapper().func_178130_a(block);
            if (holder.property != null && block.func_176223_P().func_177227_a().contains(holder.property)) {
                defaultState = block.func_176223_P().func_177226_a(holder.property, holder.defaultsValue);
                defaultMrl = (ModelResourceLocation)locations.get(defaultState);
                defaultBakedModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)defaultMrl);
                if (defaultBakedModel == null) {
                    throw new RuntimeException("Model for state " + defaultState + " failed to load from " + defaultMrl + ". " + SmartModelAttacher.debugOutput((IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry(), defaultMrl));
                }
                RelayingBakedModel model = new RelayingBakedModel(defaultBakedModel);
                ModelResourceLocation itemMrl = new ModelResourceLocation(defaultMrl.func_110624_b() + ":" + defaultMrl.func_110623_a() + "#inventory");
                event.getModelRegistry().func_82595_a((Object)itemMrl, (Object)model);
                for (Map.Entry entry : locations.entrySet()) {
                    if (((IBlockState)entry.getKey()).func_177229_b(holder.property) == holder.autoValue) {
                        event.getModelRegistry().func_82595_a(entry.getValue(), (Object)model);
                        continue;
                    }
                    if (event.getModelRegistry().func_82594_a(entry.getValue()) != null) continue;
                    event.getModelRegistry().func_82595_a(entry.getValue(), (Object)defaultBakedModel);
                }
                continue;
            }
            defaultState = block.func_176223_P();
            defaultMrl = (ModelResourceLocation)locations.get(defaultState);
            defaultBakedModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)defaultMrl);
            if (!holder.itemOnly) {
                for (ModelResourceLocation mrl : locations.values()) {
                    IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)mrl);
                    event.getModelRegistry().func_82595_a((Object)mrl, (Object)new RelayingBakedModel(model != null ? model : defaultBakedModel));
                }
            }
            ModelResourceLocation itemMrl = new ModelResourceLocation(defaultMrl.func_110624_b() + ":" + defaultMrl.func_110623_a() + "#inventory");
            if (event.getModelRegistry().func_82594_a((Object)itemMrl) == null) {
                event.getModelRegistry().func_82595_a((Object)itemMrl, (Object)new RelayingBakedModel(defaultBakedModel));
                continue;
            }
            event.getModelRegistry().func_82595_a((Object)itemMrl, (Object)new RelayingBakedModel((IBakedModel)event.getModelRegistry().func_82594_a((Object)itemMrl)));
        }
        OverlayHolder.collectOverlayQuads(event);
        BlockStateWrapperBase.invalidate();
        BlockStateWrapperConduitBundle.invalidate();
    }

    private static String debugOutput(IRegistry<ModelResourceLocation, IBakedModel> modelRegistry, ModelResourceLocation defaultMrl) {
        String prefix = defaultMrl.func_110624_b() + ":" + defaultMrl.func_110623_a();
        if (modelRegistry instanceof RegistrySimple) {
            RegistrySimple rg = (RegistrySimple)modelRegistry;
            StringBuilder sb = new StringBuilder();
            for (Object key : rg.func_148742_b()) {
                if (!key.toString().startsWith(prefix)) continue;
                sb.append(key + "; ");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 2);
            } else {
                sb.append("(none)");
            }
            return "Loaded states for " + prefix + " are: " + sb.toString();
        }
        return "Loaded states could not be determined because modelRegistry is not a RegistrySimple.";
    }

    private static class RegistrationHolder<T extends Comparable<T>, V extends T> {
        Block block;
        IProperty<T> property;
        V defaultsValue;
        V autoValue;
        boolean itemOnly;

        protected RegistrationHolder(Block block, IProperty<T> property, V defaultsValue, V autoValue, boolean itemOnly) {
            this.block = block;
            this.property = property;
            this.defaultsValue = defaultsValue;
            this.autoValue = autoValue;
            this.itemOnly = itemOnly;
        }
    }
}

