/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render;

import crazypants.enderio.EnderIO;
import crazypants.enderio.render.RotatingSmartItemModel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ItemModelRegistry {
    private static final Map<ModelResourceLocation, Registry> registries = new HashMap<ModelResourceLocation, Registry>();

    private ItemModelRegistry() {
    }

    public static void create() {
        MinecraftForge.EVENT_BUS.register((Object)new ItemModelRegistry());
    }

    public static void register(String resource, Registry registry) {
        registries.put(new ModelResourceLocation(EnderIO.DOMAIN + ":" + resource + "#inventory"), registry);
    }

    public static void register(ModelResourceLocation resource, Registry registry) {
        registries.put(resource, registry);
    }

    public static void registerRotating(String resource, final int speed) {
        ItemModelRegistry.register(resource, new Registry(){

            @Override
            public IBakedModel wrap(IBakedModel model) {
                return new RotatingSmartItemModel((IPerspectiveAwareModel)model, speed);
            }
        });
    }

    @SubscribeEvent
    public void bakeModels(ModelBakeEvent event) {
        for (Map.Entry<ModelResourceLocation, Registry> entry : registries.entrySet()) {
            IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)entry.getKey());
            event.getModelRegistry().func_82595_a((Object)entry.getKey(), (Object)entry.getValue().wrap(model));
        }
    }

    public static interface Registry {
        public IBakedModel wrap(IBakedModel var1);
    }
}

