/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material.fusedQuartz;

import com.enderio.core.common.BlockEnder;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.blocks.TileEntityPaintedBlock;
import crazypants.enderio.machine.painter.recipe.BasicPainterTemplate;
import crazypants.enderio.material.fusedQuartz.BlockFusedQuartzBase;
import crazypants.enderio.material.fusedQuartz.FusedQuartzType;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.render.PaintHelper;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.SmartModelAttacher;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPaintedFusedQuartz
extends BlockFusedQuartzBase<TileEntityPaintedBlock>
implements ITileEntityProvider,
IPaintable.IBlockPaintableBlock {
    public static BlockPaintedFusedQuartz create() {
        BlockPaintedFusedQuartz result = new BlockPaintedFusedQuartz();
        result.init();
        return result;
    }

    private BlockPaintedFusedQuartz() {
        super(ModObject.blockPaintedFusedQuartz.getUnlocalisedName(), TileEntityPaintedBlock.class);
        this.func_149647_a(null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FusedQuartzType.KIND, (Comparable)((Object)FusedQuartzType.FUSED_QUARTZ)));
    }

    protected void init() {
        super.init();
        SmartModelAttacher.registerNoProps((Block)this);
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.getUnlocalisedName(), new BasicPainterTemplate<BlockPaintedFusedQuartz>(this, new Block[]{EnderIO.blockFusedQuartz}){

            @Override
            public ItemStack isUnpaintingOp(ItemStack paintSource, ItemStack target) {
                if (paintSource == null || target == null) {
                    return null;
                }
                Block paintBlock = PainterUtil2.getBlockFromItem(paintSource);
                Block targetBlock = Block.func_149634_a((Item)target.func_77973_b());
                if (paintBlock == null || targetBlock == null) {
                    return null;
                }
                if (paintBlock == EnderIO.blockFusedQuartz && paintSource.func_77952_i() == target.func_77952_i()) {
                    return new ItemStack((Block)EnderIO.blockFusedQuartz, 1, target.func_77952_i());
                }
                return null;
            }
        });
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FusedQuartzType.KIND});
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, null);
            blockStateWrapper.addCacheKey(0);
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_185485_f(IBlockState bs) {
        return 1.0f;
    }

    public boolean doesSideBlockRendering(IBlockState bs, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityPaintedBlock();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        this.setPaintSource(state, (IBlockAccess)world, pos, PainterUtil2.getSourceBlock(stack));
        if (!world.field_72995_K) {
            IBlockState bs = world.func_180495_p(pos);
            world.func_184138_a(pos, bs, bs, 3);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List drops = super.getDrops(world, pos, state, fortune);
        for (ItemStack drop : drops) {
            PainterUtil2.setSourceBlock(drop, this.getPaintSource(state, world, pos));
        }
        return drops;
    }

    public ItemStack getPickBlock(IBlockState bs, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack pickBlock = super.getPickBlock(bs, target, world, pos, player);
        PainterUtil2.setSourceBlock(pickBlock, this.getPaintSource(null, (IBlockAccess)world, pos));
        return pickBlock;
    }

    @Override
    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            ((IPaintable.IPaintableTileEntity)te).setPaintSource(paintSource);
        }
    }

    @Override
    public void setPaintSource(Block block, ItemStack stack, @Nullable IBlockState paintSource) {
        PainterUtil2.setSourceBlock(stack, paintSource);
    }

    @Override
    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            return ((IPaintable.IPaintableTileEntity)te).getPaintSource();
        }
        return null;
    }

    @Override
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        return PainterUtil2.getSourceBlock(stack);
    }

    public IBlockState getFacade(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState paintSource = this.getPaintSource(this.func_176223_P(), world, pos);
        return paintSource != null ? paintSource : world.func_180495_p(pos);
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }
}

