/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver.gui;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.widget.GuiScrollableList;
import com.enderio.core.client.render.ColorUtil;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.gui.GuiTransceiver;
import java.awt.Color;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.VertexBuffer;

public class GuiChannelList
extends GuiScrollableList<Channel> {
    private FluentIterable<Channel> channels;
    private final GuiTransceiver parent;

    public GuiChannelList(GuiTransceiver parent, int width, int height, int originX, int originY) {
        super(width, height, originX, originY, Minecraft.func_71410_x().field_71466_p.field_78288_b + 4);
        this.parent = parent;
    }

    void setChannels(Set<Channel> val, Predicate<Channel> filter) {
        if (val == null) {
            this.channels = FluentIterable.from((Iterable)Sets.newHashSet());
        }
        this.channels = FluentIterable.from(val).filter(filter);
    }

    public int getNumElements() {
        return this.channels.size();
    }

    public Channel getElementAt(int index) {
        if (index < 0 || index >= this.channels.size()) {
            return null;
        }
        return (Channel)this.channels.get(index);
    }

    protected boolean elementClicked(int i, boolean flag) {
        return this.getElementAt(i) != null;
    }

    protected void drawElement(int index, int xPosition, int yPosition, int rowHeight, VertexBuffer renderer) {
        if (index < 0 || index >= this.channels.size()) {
            return;
        }
        Channel c = this.getElementAt(index);
        if (c == null) {
            return;
        }
        int col = ColorUtil.getRGB((Color)Color.white);
        this.parent.func_73731_b(this.parent.getFontRenderer(), c.getName(), xPosition + this.margin, yPosition + this.margin / 2, col);
        if (!c.isPublic()) {
            IconEIO.map.render((IWidgetIcon)IconEIO.LOCK_LOCKED, (double)(xPosition + this.width - 18), (double)(yPosition - 3), 16.0, 15.0, 0.0, true);
        }
    }
}

