/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.tank;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.ItemUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.fluid.SmartTankFluidHandler;
import crazypants.enderio.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.tank.PacketTankFluid;
import crazypants.enderio.machine.tank.VoidMode;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.tool.SmartTank;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileTank
extends AbstractMachineEntity
implements ITankAccess.IExtendedTankAccess,
IPaintable.IPaintableTileEntity {
    private static int IO_MB_TICK = 100;
    @Store
    protected SmartTank tank;
    protected int lastUpdateLevel = -1;
    private boolean tankDirty = false;
    private int lastFluidLuminosity = 0;
    @Store
    private VoidMode voidMode = VoidMode.NEVER;
    private static long lastSendTickAll = -1L;
    private long nextSendTickThis = -1L;
    private int sendPrio = 0;
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileTank(int meta) {
        super(new SlotDefinition(0, 2, 3, 4, -1, -1));
        this.tank = meta == 1 ? new SmartTank(32000) : new SmartTank(16000);
        this.tank.setTileEntity((TileEntity)this);
    }

    public TileTank() {
        this(0);
    }

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        boolean res = super.doPush(dir);
        if (dir != null && this.tank.getFluidAmount() > 0 && FluidWrapper.transfer((FluidTank)this.tank, (IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (int)IO_MB_TICK) > 0) {
            this.setTanksDirty();
        }
        return res;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        boolean res = super.doPull(dir);
        if (dir != null && this.tank.getFluidAmount() < this.tank.getCapacity() && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.tank, (int)IO_MB_TICK) > 0) {
            this.setTanksDirty();
        }
        return res;
    }

    private int getFilledLevel() {
        int level = (int)Math.floor(16.0f * this.tank.getFilledRatio());
        if (level == 0 && this.tank.getFluidAmount() > 0) {
            level = 1;
        }
        return level;
    }

    public boolean canVoidItems() {
        return this.tank.getFluid() != null && this.tank.getFluid().getFluid().getTemperature() > 973;
    }

    public VoidMode getVoidMode() {
        return this.voidMode;
    }

    public void setVoidMode(VoidMode mode) {
        this.voidMode = mode;
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "tank";
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack item) {
        if (this.canVoidItems() && this.voidMode == VoidMode.ALWAYS && i < this.getSlotDefinition().getMaxInputSlot()) {
            return false;
        }
        if (i == 0) {
            return FluidUtil.getFluidTypeFromItem((ItemStack)item) != null;
        }
        if (i == 1) {
            return FluidUtil.hasEmptyCapacity((ItemStack)item);
        }
        if (i == 2 && this.canVoidItems()) {
            return this.voidMode == VoidMode.ALWAYS || this.voidMode != VoidMode.NEVER && !FluidUtil.isFluidContainer((ItemStack)item);
        }
        return false;
    }

    @Override
    public void func_70299_a(int slot, @Nullable ItemStack contents) {
        super.func_70299_a(slot, contents);
    }

    @Override
    public boolean isActive() {
        return false;
    }

    private boolean canSendClientUpdate() {
        long tick = EnderIO.proxy.getTickCount();
        if (this.nextSendTickThis > tick) {
            return false;
        }
        if (tick == lastSendTickAll && this.sendPrio++ < 200) {
            return false;
        }
        lastSendTickAll = tick;
        this.nextSendTickThis = lastSendTickAll + 10L + (long)(this.sendPrio * 2);
        this.sendPrio = 0;
        return true;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        this.processItems(redstoneCheck);
        int filledLevel = this.getFilledLevel();
        if (this.lastUpdateLevel != filledLevel) {
            this.lastUpdateLevel = filledLevel;
            this.setTanksDirty();
        }
        if (this.tankDirty && this.canSendClientUpdate()) {
            int thisFluidLuminosity;
            PacketHandler.sendToAllAround((IMessage)new PacketTankFluid(this), (TileEntity)this);
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
            int n = thisFluidLuminosity = this.tank.getFluid() == null || this.tank.getFluid().getFluid() == null || this.tank.getFluidAmount() == 0 ? 0 : this.tank.getFluid().getFluid().getLuminosity(this.tank.getFluid());
            if (thisFluidLuminosity != this.lastFluidLuminosity) {
                this.field_145850_b.func_175664_x(this.func_174877_v());
                this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                this.lastFluidLuminosity = thisFluidLuminosity;
            }
            this.tankDirty = false;
        }
        return false;
    }

    public int getComparatorOutput() {
        if (this.tank.isEmpty()) {
            return 0;
        }
        return (int)(1.0 + (double)this.tank.getFluidAmount() / (double)this.tank.getCapacity() * 14.0);
    }

    private boolean processItems(boolean redstoneCheck) {
        if (!redstoneCheck) {
            return false;
        }
        if (!this.shouldDoWorkThisTick(20)) {
            return false;
        }
        if (this.canVoidItems()) {
            this.inventory[2] = null;
            this.func_70296_d();
        }
        return this.drainFullContainer() || this.fillEmptyContainer();
    }

    private boolean fillEmptyContainer() {
        FluidUtil.FluidAndStackResult fill = FluidUtil.tryFillContainer((ItemStack)this.inventory[this.getSlotDefinition().getMinInputSlot() + 1], (FluidStack)this.getOutputTanks()[0].getFluid());
        if (fill.result.fluidStack == null) {
            return false;
        }
        int slot = this.getSlotDefinition().getMaxOutputSlot();
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].func_77985_e() && ItemUtil.areStackMergable((ItemStack)this.inventory[slot], (ItemStack)fill.result.itemStack) && this.inventory[slot].field_77994_a < this.inventory[slot].func_77976_d()) {
                fill.result.itemStack.field_77994_a += this.inventory[slot].field_77994_a;
            } else {
                return false;
            }
        }
        this.getOutputTanks()[0].setFluid(fill.remainder.fluidStack);
        this.func_70299_a(this.getSlotDefinition().getMinInputSlot() + 1, fill.remainder.itemStack);
        this.func_70299_a(slot, fill.result.itemStack);
        this.setTanksDirty();
        this.func_70296_d();
        return false;
    }

    private boolean drainFullContainer() {
        FluidUtil.FluidAndStackResult fill = FluidUtil.tryDrainContainer((ItemStack)this.inventory[this.getSlotDefinition().getMinInputSlot()], (ITankAccess)this);
        if (fill.result.fluidStack == null) {
            return false;
        }
        int slot = this.getSlotDefinition().getMinOutputSlot();
        if (this.inventory[slot] != null && fill.result.itemStack != null) {
            if (this.inventory[slot].func_77985_e() && ItemUtil.areStackMergable((ItemStack)this.inventory[slot], (ItemStack)fill.result.itemStack) && this.inventory[slot].field_77994_a < this.inventory[slot].func_77976_d()) {
                fill.result.itemStack.field_77994_a += this.inventory[slot].field_77994_a;
            } else {
                return false;
            }
        }
        this.getInputTank(fill.result.fluidStack).setFluid(fill.remainder.fluidStack);
        this.func_70299_a(this.getSlotDefinition().getMinInputSlot(), fill.remainder.itemStack);
        if (fill.result.itemStack != null) {
            this.func_70299_a(slot, fill.result.itemStack);
        }
        this.setTanksDirty();
        this.func_70296_d();
        return false;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return this.tank;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.tank};
    }

    public void setTanksDirty() {
        if (!this.tankDirty) {
            this.tankDirty = true;
            this.func_70296_d();
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1 && this.tank.getFluidAmount() > 0;
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        return Collections.singletonList(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.STORAGE;
            }

            @Nullable
            public FluidStack getContent() {
                return TileTank.this.tank.getFluid();
            }

            public int getCapacity() {
                return TileTank.this.tank.getCapacity();
            }
        });
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler(this, new IFluidHandler[]{this.tank});
        }
        return this.smartTankFluidHandler;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getSmartTankFluidHandler().has(facingIn);
        }
        return super.hasCapability(capability, facingIn);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getSmartTankFluidHandler().get(facingIn);
        }
        return (T)super.getCapability(capability, facingIn);
    }
}

