/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawner;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.PoweredTask;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.ranged.IRanged;
import crazypants.enderio.machine.ranged.RangeParticle;
import crazypants.enderio.machine.spawner.DummyRecipe;
import crazypants.enderio.machine.spawner.PoweredSpawnerConfig;
import crazypants.enderio.paint.IPaintable;
import crazypants.util.CapturedMob;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TilePoweredSpawner
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity,
IRanged {
    @Store(value={Store.StoreFor.CLIENT, Store.StoreFor.SAVE})
    private CapturedMob capturedMob = null;
    @Store
    private boolean isSpawnMode = true;
    private int remainingSpawnTries;
    private BoundingBox bounds;
    private boolean showingRange;
    private static final Vector4f color = new Vector4f(0.94f, 0.11f, 0.11f, 0.4f);

    public TilePoweredSpawner() {
        super(new SlotDefinition(1, 1, 1), CapacitorKey.SPAWNER_POWER_INTAKE, CapacitorKey.SPAWNER_POWER_BUFFER, CapacitorKey.SPAWNER_POWER_USE);
    }

    public boolean isSpawnMode() {
        return this.isSpawnMode;
    }

    public void setSpawnMode(boolean isSpawnMode) {
        if (isSpawnMode != this.isSpawnMode) {
            this.currentTask = null;
        }
        this.isSpawnMode = isSpawnMode;
    }

    @Override
    protected void taskComplete() {
        super.taskComplete();
        if (this.hasEntity()) {
            if (this.isSpawnMode) {
                this.remainingSpawnTries = Config.poweredSpawnerSpawnCount + Config.poweredSpawnerMaxSpawnTries;
                for (int i = 0; i < Config.poweredSpawnerSpawnCount && this.remainingSpawnTries > 0 && this.trySpawnEntity(); ++i) {
                }
            } else {
                if (this.func_70301_a(0) == null || this.func_70301_a(1) != null || !this.hasEntity()) {
                    return;
                }
                ItemStack res = this.capturedMob.toStack(EnderIO.itemSoulVessel, 1, 1);
                this.func_70298_a(0, 1);
                this.func_70299_a(1, res);
            }
        } else {
            this.field_145850_b.func_175655_b(this.func_174877_v(), true);
        }
    }

    @Override
    public int getPowerUsePerTick() {
        return (int)((double)super.getPowerUsePerTick() * PoweredSpawnerConfig.getInstance().getCostMultiplierFor(this.getEntityName()));
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        return (int)((double)super.getMaxEnergyRecieved(dir) * PoweredSpawnerConfig.getInstance().getCostMultiplierFor(this.getEntityName()));
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockPoweredSpawner.getUnlocalisedName();
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (itemstack == null || this.isSpawnMode) {
            return false;
        }
        if (this.slotDefinition.isInputSlot(i)) {
            return itemstack.func_77973_b() == EnderIO.itemSoulVessel && !CapturedMob.containsSoul(itemstack);
        }
        return false;
    }

    @Override
    protected IMachineRecipe canStartNextTask(float chance) {
        BlockPos p;
        if (!this.hasEntity()) {
            return null;
        }
        if (this.isSpawnMode ? Config.poweredSpawnerMaxPlayerDistance > 0 && this.field_145850_b.func_184137_a((double)(p = this.func_174877_v()).func_177958_n() + 0.5, (double)p.func_177958_n() + 0.5, (double)p.func_177958_n() + 0.5, (double)Config.poweredSpawnerMaxPlayerDistance, false) == null : this.func_70301_a(0) == null || this.func_70301_a(1) != null) {
            return null;
        }
        return new DummyRecipe();
    }

    @Override
    protected boolean startNextTask(IMachineRecipe nextRecipe, float chance) {
        return super.startNextTask(nextRecipe, chance);
    }

    @Override
    protected boolean hasInputStacks() {
        return true;
    }

    @Override
    protected boolean canInsertResult(float chance, IMachineRecipe nextRecipe) {
        return true;
    }

    @Override
    public void writeToItemStack(ItemStack stack) {
        super.writeToItemStack(stack);
        if (this.hasEntity() && stack != null) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            this.capturedMob.toNbt(stack.func_77978_p());
        }
    }

    @Override
    protected void updateEntityClient() {
        if (this.isActive()) {
            double x = (float)this.func_174877_v().func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
            double y = (float)this.func_174877_v().func_177956_o() + this.field_145850_b.field_73012_v.nextFloat();
            double z = (float)this.func_174877_v().func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
        super.updateEntityClient();
    }

    @Override
    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        PoweredTask res = new PoweredTask(nextRecipe, chance, this.getRecipeInputs());
        int ticksDelay = this.isSpawnMode ? Config.poweredSpawnerMinDelayTicks + (int)Math.round((double)(Config.poweredSpawnerMaxDelayTicks - Config.poweredSpawnerMinDelayTicks) * Math.random()) : Config.poweredSpawnerMaxDelayTicks - (Config.poweredSpawnerMaxDelayTicks - Config.poweredSpawnerMinDelayTicks) / 2;
        int powerPerTick = this.getPowerUsePerTick();
        res.setRequiredEnergy(powerPerTick * (ticksDelay /= CapacitorKey.SPAWNER_SPEEDUP.get(this.getCapacitorData())));
        return res;
    }

    protected boolean canSpawnEntity(EntityLiving entityliving) {
        boolean spaceClear;
        boolean bl = spaceClear = this.field_145850_b.func_72855_b(entityliving.func_174813_aQ()) && this.field_145850_b.func_184144_a((Entity)entityliving, entityliving.func_174813_aQ()).isEmpty() && (!this.field_145850_b.func_72953_d(entityliving.func_174813_aQ()) || entityliving.isCreatureType(EnumCreatureType.WATER_CREATURE, false));
        if (spaceClear && Config.poweredSpawnerUseVanillaSpawChecks) {
            spaceClear = entityliving.func_70601_bi();
        }
        return spaceClear;
    }

    Entity createEntity(DifficultyInstance difficulty, boolean forceAlive) {
        Entity ent = this.capturedMob.getEntity(this.field_145850_b, this.field_174879_c, difficulty, false);
        if (forceAlive && Config.poweredSpawnerMaxPlayerDistance <= 0 && Config.poweredSpawnerDespawnTimeSeconds > 0 && ent instanceof EntityLiving) {
            ent.getEntityData().func_74772_a("spawnedByPoweredSpawner", this.field_145850_b.func_82737_E());
            ((EntityLiving)ent).func_110163_bv();
        }
        return ent;
    }

    protected boolean trySpawnEntity() {
        int nearbyEntities;
        Entity entity = this.createEntity(this.field_145850_b.func_175649_E(this.func_174877_v()), true);
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        int spawnRange = this.getRange();
        if (Config.poweredSpawnerMaxNearbyEntities > 0 && (nearbyEntities = this.field_145850_b.func_72872_a(entity.getClass(), (AxisAlignedBB)this.getBounds().expand((double)spawnRange, 2.0, (double)spawnRange)).size()) >= Config.poweredSpawnerMaxNearbyEntities) {
            return false;
        }
        while (this.remainingSpawnTries-- > 0) {
            double x = (double)this.func_174877_v().func_177958_n() + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)spawnRange;
            double y = this.func_174877_v().func_177956_o() + this.field_145850_b.field_73012_v.nextInt(3) - 1;
            double z = (double)this.func_174877_v().func_177952_p() + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)spawnRange;
            entity.func_70012_b(x, y, z, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (!this.canSpawnEntity(entityliving)) continue;
            this.field_145850_b.func_72838_d((Entity)entityliving);
            this.field_145850_b.func_175718_b(2004, this.func_174877_v(), 0);
            entityliving.func_70656_aK();
            Entity ridingEntity = entity.func_184187_bx();
            if (ridingEntity != null) {
                ridingEntity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, 0.0f);
            }
            for (Entity passenger : entity.func_184188_bt()) {
                passenger.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, 0.0f);
            }
            return true;
        }
        Entity ridingEntity = entity.func_184187_bx();
        if (ridingEntity != null) {
            ridingEntity.func_70106_y();
        }
        for (Entity passenger : entity.func_184188_bt()) {
            passenger.func_70106_y();
        }
        return false;
    }

    public String getEntityName() {
        return this.capturedMob != null ? this.capturedMob.getEntityName() : null;
    }

    public CapturedMob getEntity() {
        return this.capturedMob;
    }

    public boolean hasEntity() {
        return this.capturedMob != null;
    }

    @Override
    public void readFromItemStack(ItemStack stack) {
        super.readFromItemStack(stack);
        this.capturedMob = CapturedMob.create(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(new RangeParticle<TilePoweredSpawner>(this, color));
        }
    }

    @Override
    public void onCapacitorDataChange() {
        super.onCapacitorDataChange();
        this.bounds = null;
    }

    @Override
    public BoundingBox getBounds() {
        if (this.isSpawnMode) {
            if (this.bounds == null) {
                Entity ent;
                this.bounds = new BoundingBox(this.func_174877_v()).expand((double)this.getRange(), 1.0, (double)this.getRange());
                if (this.capturedMob != null && (ent = this.capturedMob.getEntity(this.field_145850_b, false)) != null) {
                    int height = Math.max((int)Math.ceil(ent.field_70131_O) - 1, 0);
                    this.bounds = this.bounds.setMaxY(this.bounds.field_72337_e + (double)height);
                }
            }
            return this.bounds;
        }
        return new BoundingBox(this.func_174877_v());
    }

    public int getRange() {
        return Config.poweredSpawnerSpawnRange;
    }
}

