/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.soul;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.recipe.RecipeBonusType;
import crazypants.enderio.machine.soul.ISoulBinderRecipe;
import crazypants.enderio.xp.XpUtil;
import crazypants.util.CapturedMob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class AbstractSoulBinderRecipe
implements IMachineRecipe,
ISoulBinderRecipe {
    private final int energyRequired;
    private final String uid;
    private final int xpLevelsRequired;
    private final int xpRequired;
    private final List<String> supportedEntities;

    protected AbstractSoulBinderRecipe(int energyRequired, int xpLevelsRequired, String uid, Class<?> entityClass) {
        this(energyRequired, xpLevelsRequired, uid, (String)EntityList.field_75626_c.get(entityClass));
    }

    protected AbstractSoulBinderRecipe(int energyRequired, int xpLevelsRequired, String uid, String ... entityNames) {
        this.energyRequired = energyRequired;
        this.xpLevelsRequired = xpLevelsRequired;
        this.xpRequired = XpUtil.getExperienceForLevel(xpLevelsRequired);
        this.uid = uid;
        this.supportedEntities = Arrays.asList(entityNames);
    }

    protected AbstractSoulBinderRecipe(int energyRequired, int xpLevelsRequired, String uid) {
        this(energyRequired, xpLevelsRequired, uid, new String[0]);
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public int getExperienceLevelsRequired() {
        return this.xpLevelsRequired;
    }

    @Override
    public int getExperienceRequired() {
        return this.xpRequired;
    }

    @Override
    public int getEnergyRequired(MachineRecipeInput ... inputs) {
        return this.getEnergyRequired();
    }

    @Override
    public RecipeBonusType getBonusType(MachineRecipeInput ... inputs) {
        return RecipeBonusType.NONE;
    }

    @Override
    public boolean isRecipe(MachineRecipeInput ... inputs) {
        int validCount = 0;
        for (MachineRecipeInput input : inputs) {
            if (this.isValidInput(input)) {
                ++validCount;
                continue;
            }
            return false;
        }
        return validCount == 2;
    }

    @Override
    public IMachineRecipe.ResultStack[] getCompletedResult(float randomChance, MachineRecipeInput ... inputs) {
        CapturedMob mobType = null;
        ItemStack inputItem = null;
        for (MachineRecipeInput input : inputs) {
            if (input != null && input.slotNumber == 0 && CapturedMob.containsSoul(input.item)) {
                mobType = CapturedMob.create(input.item);
                continue;
            }
            if (input == null || input.slotNumber != 1 || !this.isValidInputItem(input.item)) continue;
            inputItem = input.item;
        }
        if (!this.isValidInputSoul(mobType) || inputItem == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        ItemStack resultStack = this.getOutputStack(inputItem, mobType);
        ItemStack soulVessel = new ItemStack((Item)EnderIO.itemSoulVessel);
        return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(soulVessel), new IMachineRecipe.ResultStack(resultStack)};
    }

    @Override
    public float getExperienceForOutput(ItemStack output) {
        return 0.0f;
    }

    @Override
    public boolean isValidInput(MachineRecipeInput input) {
        if (input == null || input.item == null) {
            return false;
        }
        int slot = input.slotNumber;
        ItemStack item = input.item;
        if (slot == 0) {
            CapturedMob mobType = CapturedMob.create(item);
            return mobType != null && item.func_77973_b() == EnderIO.itemSoulVessel && this.isValidInputSoul(mobType);
        }
        if (slot == 1) {
            return this.isValidInputItem(item);
        }
        return false;
    }

    protected boolean isValidInputSoul(CapturedMob mobType) {
        return this.getSupportedSouls().contains(mobType.getEntityName());
    }

    protected boolean isValidInputItem(ItemStack item) {
        return item.func_77969_a(this.getInputStack());
    }

    @Override
    public String getMachineName() {
        return ModObject.blockSoulBinder.getUnlocalisedName();
    }

    @Override
    public List<MachineRecipeInput> getQuantitiesConsumed(MachineRecipeInput[] inputs) {
        ArrayList<MachineRecipeInput> result = new ArrayList<MachineRecipeInput>(inputs.length);
        for (MachineRecipeInput input : inputs) {
            if (input == null || input.item == null) continue;
            ItemStack resStack = input.item.func_77946_l();
            resStack.field_77994_a = 1;
            MachineRecipeInput mri = new MachineRecipeInput(input.slotNumber, resStack);
            result.add(mri);
        }
        return result;
    }

    protected abstract ItemStack getOutputStack(ItemStack var1, CapturedMob var2);

    @Override
    public List<String> getSupportedSouls() {
        return this.supportedEntities;
    }

    @Override
    public int getEnergyRequired() {
        return this.energyRequired;
    }
}

