/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.sagmill;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.PoweredTask;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.recipe.RecipeBonusType;
import crazypants.enderio.machine.sagmill.IGrindingMultiplier;
import crazypants.enderio.machine.sagmill.PacketGrindingBall;
import crazypants.enderio.machine.sagmill.SagMillRecipeManager;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

@Storable
public class TileSagMill
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity {
    @Store
    protected IGrindingMultiplier gb;
    @Store
    protected int currGbUse = 0;
    @Store
    protected int maxGbUse = 0;
    protected int lastSendGbScaled = 0;
    private boolean useGrindingBall;

    public TileSagMill() {
        super(new SlotDefinition(2, 4), ModObject.blockSagMill);
    }

    @Override
    public String func_70005_c_() {
        return ModObject.blockSagMill.getUnlocalisedName();
    }

    @Override
    public String getMachineName() {
        return ModObject.blockSagMill.getUnlocalisedName();
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return SagMillRecipeManager.instance.isValidInput(new MachineRecipeInput(i, itemstack));
    }

    public int getBallDurationScaled(int scale) {
        return this.maxGbUse > 0 ? (int)((float)scale * (1.0f - (float)this.currGbUse / (float)this.maxGbUse)) : 0;
    }

    @Override
    protected double usePower() {
        double res = super.usePower();
        boolean sendGB = false;
        if (this.gb != null && this.useGrindingBall) {
            this.currGbUse = (int)((double)this.currGbUse + res);
            if (this.currGbUse >= this.gb.getDurationMJ()) {
                this.currGbUse = 0;
                this.maxGbUse = 0;
                this.gb = null;
                sendGB = true;
            } else {
                int newScaled = this.getBallDurationScaled(16);
                if (newScaled != this.lastSendGbScaled) {
                    sendGB = true;
                }
            }
        }
        if (this.gb == null) {
            this.gb = SagMillRecipeManager.getInstance().getGrindballFromStack(this.inventory[1]);
            if (this.gb != null) {
                this.maxGbUse = this.gb.getDurationMJ();
                this.func_70298_a(1, 1);
                this.func_70296_d();
                sendGB = false;
            }
        }
        if (sendGB) {
            PacketHandler.sendToAllAround(new PacketGrindingBall(this), (TileEntity)this);
            this.lastSendGbScaled = this.getBallDurationScaled(16);
        }
        return res;
    }

    @Override
    protected void taskComplete() {
        IPoweredTask ct = this.currentTask;
        super.taskComplete();
        if (this.gb != null && this.useGrindingBall && ct != null && ct.getBonusType() == RecipeBonusType.MULTIPLY_OUTPUT) {
            float chance = this.random.nextFloat();
            for (float mul = this.gb.getGrindingMultiplier() - 1.0f; mul > 0.0f; mul -= 1.0f) {
                if (!(chance <= mul)) continue;
                this.currentTask = ct;
                super.taskComplete();
            }
        }
    }

    @Override
    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        PoweredTask res;
        this.useGrindingBall = false;
        if (this.gb != null) {
            boolean bl = this.useGrindingBall = !SagMillRecipeManager.getInstance().isExcludedFromBallBonus(this.getRecipeInputs());
            if (this.useGrindingBall) {
                res = new PoweredTask(nextRecipe, chance / this.gb.getChanceMultiplier(), this.getRecipeInputs());
                res.setRequiredEnergy(res.getRequiredEnergy() * this.gb.getPowerMultiplier());
            } else {
                res = new PoweredTask(nextRecipe, chance, this.getRecipeInputs());
            }
        } else {
            res = new PoweredTask(nextRecipe, chance, this.getRecipeInputs());
        }
        return res;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        this.lastSendGbScaled = this.getBallDurationScaled(16);
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public String getSoundName() {
        return "machine.sagmill";
    }

    @Override
    public float getVolume() {
        return super.getVolume() * 0.125f;
    }
}

