/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.inhibitor;

import com.enderio.core.common.util.BlockCoord;
import com.google.common.collect.Maps;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.machine.obelisk.AbstractBlockObelisk;
import crazypants.enderio.machine.obelisk.GuiRangedObelisk;
import crazypants.enderio.machine.obelisk.inhibitor.ContainerInhibitorObelisk;
import crazypants.enderio.machine.obelisk.inhibitor.TileInhibitorObelisk;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockInhibitorObelisk
extends AbstractBlockObelisk<TileInhibitorObelisk> {
    public static BlockInhibitorObelisk instance;
    public Map<BlockCoord, Float> activeInhibitors = Maps.newHashMap();

    public static BlockInhibitorObelisk create() {
        BlockInhibitorObelisk res = new BlockInhibitorObelisk();
        res.init();
        MinecraftForge.EVENT_BUS.register((Object)res);
        instance = res;
        return instance;
    }

    protected BlockInhibitorObelisk() {
        super(ModObject.blockInhibitorObelisk, TileInhibitorObelisk.class);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileInhibitorObelisk te;
        if (ID == this.getGuiId() && (te = (TileInhibitorObelisk)this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z))) != null) {
            return new ContainerInhibitorObelisk(player.field_71071_by, te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileInhibitorObelisk te;
        if (ID == this.getGuiId() && (te = (TileInhibitorObelisk)this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z))) != null) {
            return new GuiRangedObelisk(player.field_71071_by, te, (Container)new ContainerInhibitorObelisk(player.field_71071_by, te), "inhibitor");
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 104;
    }

    @SubscribeEvent
    public void onTeleport(TeleportEntityEvent event) {
        for (Map.Entry<BlockCoord, Float> e : this.activeInhibitors.entrySet()) {
            TileEntity te;
            BlockCoord bc = e.getKey();
            int dist = bc.getDist(new BlockCoord(event.targetX, event.targetY, event.targetZ));
            if (!((float)dist < e.getValue().floatValue()) || !((te = bc.getTileEntity((IBlockAccess)event.getEntity().field_70170_p)) instanceof TileInhibitorObelisk) || !((TileInhibitorObelisk)te).isActive() || te.func_145831_w().field_73011_w.getDimension() != event.dimension) continue;
            event.setCanceled(true);
        }
    }
}

