/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.remote;

import net.minecraft.item.ItemStack;

public enum ItemRemoteInvAccessType {
    BASIC("basic", 80, false, 1, true),
    ADVANCED("advanced", -1, false, 2, true),
    ENDER("ender", -1, true, 4, true);

    private final String nameSuffix;
    private final int range;
    private final boolean interdimensional;
    private final int capacity;
    private final boolean visible;

    private ItemRemoteInvAccessType(String nameSuffix, int range, boolean interdimensional, int capacity, boolean visible) {
        this.nameSuffix = nameSuffix;
        this.range = range;
        this.interdimensional = interdimensional;
        this.capacity = capacity;
        this.visible = visible;
    }

    public int toMetadata() {
        return this.ordinal();
    }

    public static ItemRemoteInvAccessType fromMetadata(int meta) {
        return ItemRemoteInvAccessType.values()[meta >= 0 && meta < ItemRemoteInvAccessType.values().length ? meta : 0];
    }

    public static ItemRemoteInvAccessType fromStack(ItemStack stack) {
        return ItemRemoteInvAccessType.fromMetadata(stack != null ? stack.func_77960_j() : 0);
    }

    public boolean inRange(int dim0, int x0, int y0, int z0, int dim1, int x1, int y1, int z1) {
        if (!this.interdimensional && dim0 != dim1) {
            return false;
        }
        if (this.range < 0) {
            return true;
        }
        return Math.abs(x0 - x1) <= this.range && Math.abs(y0 - y1) <= this.range && Math.abs(z0 - z1) <= this.range;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public String getUnlocalizedName(String basename) {
        return basename + this.getNameSuffix();
    }

    public int getRange() {
        return this.range;
    }

    public boolean isInterdimensional() {
        return this.interdimensional;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

