/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import com.enderio.core.api.common.util.ITankAccess;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.item.FilterRegister;
import crazypants.enderio.conduit.item.ItemConduit;
import crazypants.enderio.conduit.item.ItemConduitNetwork;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.fluid.SmartTankFluidHandler;
import crazypants.enderio.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.generator.zombie.IHasNutrientTank;
import crazypants.enderio.machine.generator.zombie.PacketNutrientTank;
import crazypants.enderio.machine.invpanel.InventoryPanelContainer;
import crazypants.enderio.machine.invpanel.PacketGuiSettingsUpdated;
import crazypants.enderio.machine.invpanel.PacketStoredCraftingRecipe;
import crazypants.enderio.machine.invpanel.PacketUpdateExtractionDisabled;
import crazypants.enderio.machine.invpanel.StoredCraftingRecipe;
import crazypants.enderio.machine.invpanel.client.ClientDatabaseManager;
import crazypants.enderio.machine.invpanel.client.InventoryDatabaseClient;
import crazypants.enderio.machine.invpanel.server.InventoryDatabaseServer;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.tool.SmartTank;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.handlers.enderio.HandleStoredCraftingRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileInventoryPanel
extends AbstractMachineEntity
implements ITankAccess.IExtendedTankAccess,
IHasNutrientTank {
    public static final int SLOT_CRAFTING_START = 0;
    public static final int SLOT_CRAFTING_RESULT = 9;
    public static final int SLOT_VIEW_FILTER = 10;
    public static final int SLOT_RETURN_START = 11;
    public static final int MAX_STORED_CRAFTING_RECIPES = 6;
    @Store
    protected final SmartTank fuelTank = new SmartTank(Fluids.fluidNutrientDistillation, Config.inventoryPanelFree ? 0 : 2000);
    protected boolean tanksDirty;
    private InventoryDatabaseServer dbServer;
    private InventoryDatabaseClient dbClient;
    @Store(value={Store.StoreFor.CLIENT, Store.StoreFor.SAVE})
    private boolean active;
    @Store
    private boolean extractionDisabled;
    public InventoryPanelContainer eventHandler;
    private IItemFilter itemFilter;
    @Store
    private int guiSortMode;
    @Store
    private String guiFilterString = "";
    @Store
    private boolean guiSync;
    @Store(handler=HandleStoredCraftingRecipe.HandleStoredCraftingRecipeArrayList.class)
    private final ArrayList<StoredCraftingRecipe> storedCraftingRecipes;
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileInventoryPanel() {
        super(new SlotDefinition(0, 8, 11, 20, 21, 20));
        this.fuelTank.setTileEntity((TileEntity)this);
        this.fuelTank.setCanDrain(false);
        this.storedCraftingRecipes = new ArrayList();
    }

    public InventoryDatabaseServer getDatabaseServer() {
        return this.dbServer;
    }

    public InventoryDatabaseClient getDatabaseClient(int generation) {
        if (this.dbClient != null && this.dbClient.getGeneration() != generation) {
            ClientDatabaseManager.INSTANCE.destroyDatabase(this.dbClient.getGeneration());
            this.dbClient = null;
        }
        if (this.dbClient == null) {
            this.dbClient = ClientDatabaseManager.INSTANCE.getOrCreateDatabase(generation);
        }
        return this.dbClient;
    }

    @Nullable
    public InventoryDatabaseClient getDatabaseClient() {
        return this.dbClient;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing side) {
        return false;
    }

    @Override
    protected boolean canExtractItem(int slot, ItemStack itemstack) {
        return !this.extractionDisabled && super.canExtractItem(slot, itemstack);
    }

    @Override
    protected boolean isMachineItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 10 && stack != null) {
            return FilterRegister.isItemFilter(stack) && FilterRegister.isFilterSet(stack);
        }
        return true;
    }

    @Override
    public ItemStack func_70298_a(int fromSlot, int amount) {
        ItemStack res = super.func_70298_a(fromSlot, amount);
        if (res != null && fromSlot < 9 && this.eventHandler != null) {
            this.eventHandler.func_75130_a((IInventory)this);
        }
        if (res != null && fromSlot == 10) {
            this.updateItemFilter();
        }
        return res;
    }

    @Override
    public void func_70299_a(int slot, @Nullable ItemStack contents) {
        super.func_70299_a(slot, contents);
        if (slot < 9 && this.eventHandler != null) {
            this.eventHandler.func_75130_a((IInventory)this);
        }
        if (slot == 10) {
            this.updateItemFilter();
        }
    }

    private void updateItemFilter() {
        this.itemFilter = FilterRegister.getFilterForUpgrade(this.inventory[10]);
    }

    public IItemFilter getItemFilter() {
        return this.itemFilter;
    }

    @Override
    public boolean isActive() {
        return Config.inventoryPanelFree || this.active;
    }

    @Override
    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            this.updateEntityClient();
            return;
        }
        if (this.shouldDoWorkThisTick(20)) {
            this.scanNetwork();
        }
        if (this.forceClientUpdate.peek()) {
            IBlockState bs = this.func_145831_w().func_180495_p(this.field_174879_c);
            this.func_145831_w().func_184138_a(this.field_174879_c, bs, bs, 3);
            this.func_70296_d();
        }
        if (this.tanksDirty) {
            this.tanksDirty = false;
            PacketHandler.sendToAllAround((IMessage)new PacketNutrientTank(this), (TileEntity)this);
        }
    }

    private void scanNetwork() {
        TileConduitBundle teCB;
        ItemConduit conduit;
        EnumFacing facingDir = this.getFacing();
        EnumFacing backside = facingDir.func_176734_d();
        ItemConduitNetwork icn = null;
        BlockPos p = this.field_174879_c.func_177972_a(backside);
        TileEntity te = this.field_145850_b.func_175625_s(p);
        if (te instanceof TileConduitBundle && (conduit = (teCB = (TileConduitBundle)te).getConduit(ItemConduit.class)) != null) {
            icn = (ItemConduitNetwork)conduit.getNetwork();
        }
        if (icn != null) {
            this.dbServer = icn.getDatabase();
            this.dbServer.sendChangeLogs();
            this.refuelPower(this.dbServer);
            if (this.active != this.dbServer.isOperational()) {
                this.active = this.dbServer.isOperational();
                this.forceClientUpdate.set();
            }
        } else {
            if (this.active) {
                this.forceClientUpdate.set();
            }
            this.dbServer = null;
            this.active = false;
        }
    }

    public float getAvailablePower() {
        return (float)this.getPower() * Config.inventoryPanelPowerPerMB;
    }

    public void refuelPower(InventoryDatabaseServer db) {
        float missingPower = Config.inventoryPanelPowerPerMB * 0.5f - db.getPower();
        if (missingPower > 0.0f) {
            int amount = (int)Math.ceil(missingPower / Config.inventoryPanelPowerPerMB);
            if ((amount = Math.min(amount, this.getPower())) > 0) {
                this.useNutrient(amount);
                this.dbServer.addPower((float)amount * Config.inventoryPanelPowerPerMB);
            }
        }
    }

    public void useNutrient(int amount) {
        this.fuelTank.removeFluidAmount(amount);
    }

    private int getPower() {
        return Config.inventoryPanelFree ? 100 : this.fuelTank.getFluidAmount();
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        return false;
    }

    public int getGuiSortMode() {
        return this.guiSortMode;
    }

    public String getGuiFilterString() {
        return this.guiFilterString;
    }

    public boolean getGuiSync() {
        return this.guiSync;
    }

    public void setGuiParameter(int sortMode, String filterString, boolean sync) {
        this.guiSortMode = sortMode;
        this.guiFilterString = filterString;
        this.guiSync = sync;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketGuiSettingsUpdated(this), this.field_145850_b.field_73011_w.getDimension());
            this.func_70296_d();
        }
    }

    public int getStoredCraftingRecipes() {
        return this.storedCraftingRecipes.size();
    }

    public StoredCraftingRecipe getStoredCraftingRecipe(int index) {
        if (index < 0 || index >= this.storedCraftingRecipes.size()) {
            return null;
        }
        return this.storedCraftingRecipes.get(index);
    }

    public void addStoredCraftingRecipe(StoredCraftingRecipe recipe) {
        this.storedCraftingRecipes.add(recipe);
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketStoredCraftingRecipe(0, 0, recipe));
        } else {
            this.func_70296_d();
            this.updateBlock();
        }
    }

    public void removeStoredCraftingRecipe(int index) {
        if (index >= 0 && index < this.storedCraftingRecipes.size()) {
            this.storedCraftingRecipes.remove(index);
            if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketStoredCraftingRecipe(1, index, null));
            } else {
                this.func_70296_d();
                this.updateBlock();
            }
        }
    }

    public boolean isExtractionDisabled() {
        return this.extractionDisabled;
    }

    public void setExtractionDisabled(boolean extractionDisabled) {
        this.extractionDisabled = extractionDisabled;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketUpdateExtractionDisabled(this, extractionDisabled), this.field_145850_b.field_73011_w.getDimension());
        }
    }

    void updateExtractionDisabled(boolean extractionDisabledIn) {
        this.extractionDisabled = extractionDisabledIn;
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        this.faceModes = null;
        if (this.eventHandler != null) {
            this.eventHandler.checkCraftingRecipes();
        }
        this.updateItemFilter();
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockInventoryPanel.getUnlocalisedName();
    }

    @Override
    @Nonnull
    public IoMode getIoMode(@Nullable EnumFacing face) {
        return face == this.getIODirection() ? IoMode.NONE : IoMode.DISABLED;
    }

    @Override
    public void setIoMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
    }

    @Override
    @Nonnull
    public IoMode toggleIoModeForFace(@Nullable EnumFacing faceHit) {
        return this.getIoMode(faceHit);
    }

    private EnumFacing getIODirection() {
        return this.getFacing().func_176734_d();
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null && this.fuelTank.canFill(forFluidType.getFluid())) {
            return this.fuelTank;
        }
        return null;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    @Override
    public SmartTank getNutrientTank() {
        return this.fuelTank;
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        return Collections.singletonList(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.INPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileInventoryPanel.this.fuelTank.getFluid();
            }

            public int getCapacity() {
                return TileInventoryPanel.this.fuelTank.getCapacity();
            }
        });
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler(this, new IFluidHandler[]{this.fuelTank});
        }
        return this.smartTankFluidHandler;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getSmartTankFluidHandler().has(facingIn);
        }
        return super.hasCapability(capability, facingIn);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getSmartTankFluidHandler().get(facingIn);
        }
        return (T)super.getCapability(capability, facingIn);
    }
}

