/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.gauge;

import cofh.api.energy.IEnergyHandler;
import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.BlockEnder;
import crazypants.enderio.BlockEio;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.gauge.RenderMapperGauge;
import crazypants.enderio.machine.gauge.TileGauge;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.SmartModelAttacher;
import crazypants.enderio.render.TextureRegistry;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGauge
extends BlockEio<TileGauge>
implements IResourceTooltipProvider,
ISmartRenderAwareBlock {
    public static final TextureRegistry.TextureSupplier gaugeIcon = TextureRegistry.registerTexture("blocks/blockGaugeOverlay");
    private static final double px = 0.0625;

    public static BlockGauge create() {
        BlockGauge result = new BlockGauge();
        result.init();
        return result;
    }

    private BlockGauge() {
        super(ModObject.blockGauge.getUnlocalisedName(), TileGauge.class, Material.field_151592_s);
        this.func_149713_g(255);
        this.field_149783_u = true;
    }

    protected void init() {
        super.init();
        SmartModelAttacher.registerItemOnly((Block)this);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(itemIn, tab, list);
        }
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    public boolean func_149686_d(IBlockState bs) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState bs) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        Map<EnumFacing, IEnergyHandler> sides = BlockGauge.getDisplays(world, pos);
        if (sides.isEmpty()) {
            return field_185505_j;
        }
        double minX = 1.0;
        double maxX = 0.0;
        double minY = 0.125;
        double maxY = 0.875;
        double minZ = 1.0;
        double maxZ = 0.0;
        if (sides.containsKey(EnumFacing.NORTH) || sides.containsKey(EnumFacing.SOUTH)) {
            minX = Math.min(minX, 0.375);
            maxX = Math.max(maxX, 0.625);
            if (sides.containsKey(EnumFacing.NORTH)) {
                minZ = Math.min(minZ, 0.0);
                maxZ = Math.max(maxZ, 0.03125);
            }
            if (sides.containsKey(EnumFacing.SOUTH)) {
                minZ = Math.min(minZ, 0.96875);
                maxZ = Math.max(maxZ, 1.0);
            }
        }
        if (sides.containsKey(EnumFacing.EAST) || sides.containsKey(EnumFacing.WEST)) {
            minZ = Math.min(minZ, 0.375);
            maxZ = Math.max(maxZ, 0.625);
            if (sides.containsKey(EnumFacing.WEST)) {
                minX = Math.min(minX, 0.0);
                maxX = Math.max(maxX, 0.09375);
            }
            if (sides.containsKey(EnumFacing.EAST)) {
                minX = Math.min(minX, 0.96875);
                maxX = Math.max(maxX, 1.0);
            }
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected static Map<EnumFacing, IEnergyHandler> getDisplays(IBlockAccess world, BlockPos pos) {
        EnumMap<EnumFacing, IEnergyHandler> sides = new EnumMap<EnumFacing, IEnergyHandler>(EnumFacing.class);
        for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
            IEnergyHandler eh;
            BlockPos neighbor = pos.func_177972_a(face);
            TileEntity tile = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)neighbor);
            if (!(tile instanceof IEnergyHandler) || tile instanceof TileCapBank || tile instanceof IConduitBundle || !(eh = (IEnergyHandler)tile).canConnectEnergy(face.func_176734_d())) continue;
            sides.put(face, eh);
        }
        return sides;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, World worldIn, BlockPos pos) {
        return null;
    }

    @Override
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMapperGauge.instance;
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_149739_a();
    }
}

