/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import crazypants.enderio.machine.farm.farmers.CocoaFarmer;
import crazypants.enderio.machine.farm.farmers.CustomSeedFarmer;
import crazypants.enderio.machine.farm.farmers.FarmersCommune;
import crazypants.enderio.machine.farm.farmers.FlowerPicker;
import crazypants.enderio.machine.farm.farmers.MelonFarmer;
import crazypants.enderio.machine.farm.farmers.NaturaBerryFarmer;
import crazypants.enderio.machine.farm.farmers.NetherWartFarmer;
import crazypants.enderio.machine.farm.farmers.OredictTreeFarmer;
import crazypants.enderio.machine.farm.farmers.PickableFarmer;
import crazypants.enderio.machine.farm.farmers.PlantableFarmer;
import crazypants.enderio.machine.farm.farmers.RubberTreeFarmer;
import crazypants.enderio.machine.farm.farmers.RubberTreeFarmerIC2exp;
import crazypants.enderio.machine.farm.farmers.RubberTreeFarmerTechReborn;
import crazypants.enderio.machine.farm.farmers.StemFarmer;
import crazypants.enderio.machine.farm.farmers.TreeFarmer;
import crazypants.util.Things;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public final class FarmersRegistry {
    private static final Things SAPLINGS = new Things("treeSapling");
    private static final Things WOODS = new Things("logWood", "blockSlimeCongealed");
    private static final Things FLOWERS = new Things("block:BiomesOPlenty:flowers", "block:BiomesOPlenty:flowers2", "block:Botany:flower", "block:botania:flower", "block:botania:doubleFlower1", "block:botania:doubleFlower2", "block:botania:shinyFlower", "block:botania:mushroom").add((Block)Blocks.field_150327_N).add((Block)Blocks.field_150328_O);
    public static final PlantableFarmer DEFAULT_FARMER = new PlantableFarmer();

    public static void addFarmers() {
        FarmersRegistry.addTechreborn();
        FarmersRegistry.addExtraUtilities2();
        FarmersRegistry.addNatura();
        FarmersRegistry.addIC2();
        FarmersRegistry.addMFR();
        FarmersRegistry.addFlowers();
        FarmersRegistry.addImmersiveEngineering();
        FarmersCommune.joinCommune(new StemFarmer((Block)Blocks.field_150436_aH, new ItemStack(Items.field_151120_aE)));
        FarmersCommune.joinCommune(new StemFarmer((Block)Blocks.field_150434_aF, new ItemStack((Block)Blocks.field_150434_aF)));
        FarmersCommune.joinCommune(new OredictTreeFarmer(SAPLINGS, WOODS));
        FarmersCommune.joinCommune(new TreeFarmer(true, (Block)Blocks.field_150337_Q, Blocks.field_150419_aX));
        FarmersCommune.joinCommune(new TreeFarmer(true, (Block)Blocks.field_150338_P, Blocks.field_150420_aW));
        FarmersCommune.joinCommune(new MelonFarmer(Blocks.field_150394_bc, Blocks.field_150440_ba, new ItemStack(Items.field_151081_bc)));
        FarmersCommune.joinCommune(new MelonFarmer(Blocks.field_150393_bb, Blocks.field_150423_aK, new ItemStack(Items.field_151080_bb)));
        FarmersCommune.joinCommune(new NetherWartFarmer());
        FarmersCommune.joinCommune(new CocoaFarmer());
        FarmersCommune.joinCommune(DEFAULT_FARMER);
    }

    public static void addPickable(String mod, String blockName, String itemName) {
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation(mod, blockName))) {
            Block cropBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
            Item seedItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, itemName));
            if (seedItem != null) {
                FarmersCommune.joinCommune(new PickableFarmer(cropBlock, new ItemStack(seedItem)));
            }
        }
    }

    public static CustomSeedFarmer addSeed(String mod, String blockName, String itemName, Block ... extraFarmland) {
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation(mod, blockName))) {
            Block cropBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
            Item seedItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, itemName));
            if (seedItem != null) {
                CustomSeedFarmer farmer = new CustomSeedFarmer(cropBlock, new ItemStack(seedItem));
                if (extraFarmland != null) {
                    for (Block farmland : extraFarmland) {
                        if (farmland == null) continue;
                        farmer.addTilledBlock(farmland);
                    }
                }
                FarmersCommune.joinCommune(farmer);
                return farmer;
            }
        }
        return null;
    }

    private static void addNatura() {
        Item seedItem;
        Block cropBlock;
        String mod = "Natura";
        String blockName = "N Crops";
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation(mod, blockName))) {
            cropBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
            DEFAULT_FARMER.addHarvestExlude(cropBlock);
            seedItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, "barley.seed"));
            if (seedItem != null) {
                FarmersCommune.joinCommune(new CustomSeedFarmer(cropBlock, 3, new ItemStack(seedItem)));
                FarmersCommune.joinCommune(new PickableFarmer(cropBlock, 4, 8, new ItemStack(seedItem, 1, 1)));
            }
        }
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation(mod, blockName = "BerryBush"))) {
            cropBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
            seedItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, blockName));
            if (seedItem != null) {
                for (int i = 0; i < 4; ++i) {
                    NaturaBerryFarmer farmer = new NaturaBerryFarmer(cropBlock, i, 12 + i, new ItemStack(seedItem, 1, 12 + i));
                    farmer.setRequiresFarmland(false);
                    FarmersCommune.joinCommune(farmer);
                }
            }
        }
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation(mod, blockName = "florasapling"))) {
            cropBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
            FarmersCommune.joinCommune(new TreeFarmer(cropBlock, (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, "tree")), (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, "willow")), (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, "Dark Tree"))));
        }
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation(mod, blockName = "Rare Sapling"))) {
            cropBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
            FarmersCommune.joinCommune(new TreeFarmer(cropBlock, (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, "Rare Tree"))));
        }
    }

    private static void addMFR() {
        String mod = "MineFactoryReloaded";
        String blockName = "rubberwood.sapling";
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation(mod, blockName))) {
            Block cropBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
            FarmersCommune.joinCommune(new TreeFarmer(cropBlock, (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, "rubberwood.log"))));
        }
    }

    private static void addIC2() {
        RubberTreeFarmer farmer = RubberTreeFarmerIC2exp.create();
        if (farmer != null) {
            FarmersCommune.joinCommune(farmer);
        }
    }

    private static void addExtraUtilities2() {
        CustomSeedFarmer farmer = FarmersRegistry.addSeed("extrautils2", "EnderLilly", "EnderLilly", new Block[0]);
        if (farmer != null) {
            farmer.setIgnoreGroundCanSustainCheck(true);
            farmer.setRequiresFarmland(false);
            farmer.setCheckGroundForFarmland(true);
            farmer.clearTilledBlocks();
            farmer.addTilledBlock(Blocks.field_150346_d);
            farmer.addTilledBlock((Block)Blocks.field_150349_c);
            farmer.addTilledBlock(Blocks.field_150377_bs);
        }
        if ((farmer = FarmersRegistry.addSeed("extrautils2", "RedOrchid", "RedOrchid", new Block[0])) != null) {
            farmer.setIgnoreGroundCanSustainCheck(true);
            farmer.setRequiresFarmland(false);
            farmer.setCheckGroundForFarmland(true);
            farmer.clearTilledBlocks();
            farmer.addTilledBlock(Blocks.field_150450_ax);
            farmer.addTilledBlock(Blocks.field_150439_ay);
        }
    }

    private static void addFlowers() {
        FarmersCommune.joinCommune(new FlowerPicker(FLOWERS));
    }

    private static void addImmersiveEngineering() {
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation("ImmersiveEngineering", "hemp"))) {
            Block hemp = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("ImmersiveEngineering", "hemp"));
            Item hempSeed = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("ImmersiveEngineering", "hemp"));
            if (hempSeed != null) {
                FarmersCommune.joinCommune(new StemFarmer(hemp, new ItemStack(hempSeed)));
            }
        }
    }

    private FarmersRegistry() {
    }

    private static void addTechreborn() {
        RubberTreeFarmer farmer = RubberTreeFarmerTechReborn.create();
        if (farmer != null) {
            FarmersCommune.joinCommune(farmer);
        }
    }
}

