/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.common.transform.EnderCoreMethods;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.machine.capbank.BlockCapBank;
import crazypants.enderio.machine.capbank.CapBankType;
import crazypants.enderio.power.PowerHandlerUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class BlockItemCapBank
extends ItemBlock
implements IEnergyContainerItem,
EnderCoreMethods.IOverlayRenderAware {
    public static ItemStack createItemStackWithPower(int meta, int storedEnergy) {
        ItemStack res = new ItemStack((Block)EnderIO.blockCapBank, 1, meta);
        if (storedEnergy > 0) {
            PowerHandlerUtil.setStoredEnergyForItem(res, storedEnergy);
        }
        return res;
    }

    public BlockItemCapBank(@Nonnull BlockCapBank blockCapBank, @Nonnull String name) {
        super((Block)blockCapBank);
        this.func_77627_a(true);
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.setRegistryName(name);
    }

    public int func_77647_b(int par1) {
        return par1;
    }

    @Nonnull
    public String func_77667_c(ItemStack par1ItemStack) {
        return CapBankType.getTypeFromMeta(par1ItemStack.func_77960_j()).getUnlocalizedName();
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77994_a > 1) {
            return 0;
        }
        CapBankType type = CapBankType.getTypeFromMeta(container.func_77960_j());
        int energy = this.getEnergyStored(container);
        int maxInput = type.getMaxIO();
        int energyReceived = Math.min(type.getMaxEnergyStored() - energy, Math.min(maxReceive, maxInput));
        if (!simulate && !type.isCreative()) {
            PowerHandlerUtil.setStoredEnergyForItem(container, energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77994_a > 1) {
            return 0;
        }
        CapBankType type = CapBankType.getTypeFromMeta(container.func_77960_j());
        int energy = this.getEnergyStored(container);
        int maxOutput = type.getMaxIO();
        int energyExtracted = Math.min(energy, Math.min(maxExtract, maxOutput));
        if (!simulate && !type.isCreative()) {
            PowerHandlerUtil.setStoredEnergyForItem(container, energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return CapBankType.getTypeFromMeta(container.func_77960_j()).isCreative() ? CapBankType.getTypeFromMeta(container.func_77952_i()).getMaxEnergyStored() / 2 : PowerHandlerUtil.getStoredEnergyForItem(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return CapBankType.getTypeFromMeta(container.func_77960_j()).getMaxEnergyStored();
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        if (Config.capacitorBankRenderPowerOverlayOnItem) {
            PowerBarOverlayRenderHelper.instance.render(stack, xPosition, yPosition);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return CapBankType.getTypeFromMeta(stack.func_77960_j()).isCreative() || super.func_77636_d(stack);
    }
}

