/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.buffer;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.common.transform.EnderCoreMethods;
import crazypants.enderio.EnderIO;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.capacitor.DefaultCapacitorData;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.machine.buffer.BufferType;
import crazypants.enderio.machine.buffer.TileBuffer;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.power.PowerHandlerUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockItemBuffer
extends ItemBlock
implements IEnergyContainerItem,
EnderCoreMethods.IOverlayRenderAware {
    public BlockItemBuffer(Block block, String name) {
        super(block);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.setRegistryName(name);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack stack) {
        return BufferType.values()[stack.func_77952_i()].getUnlocalizedName();
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        TileEntity te;
        super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (newState.func_177230_c() == this.field_150939_a && (te = world.func_175625_s(pos)) instanceof TileBuffer) {
            TileBuffer buffer = (TileBuffer)te;
            BufferType t = BufferType.values()[this.field_150939_a.func_176201_c(newState)];
            buffer.setHasInventory(t.hasInventory);
            buffer.setHasPower(t.hasPower);
            buffer.setCreative(t.isCreative);
            buffer.func_70296_d();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        tooltip.add(PainterUtil2.getTooltTipText(stack));
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        if (stack.field_77994_a == 1 && ((BufferType)((Object)EnderIO.blockBuffer.func_176203_a((int)stack.func_77960_j()).func_177229_b(BufferType.TYPE))).hasPower) {
            PowerBarOverlayRenderHelper.instance.render(stack, xPosition, yPosition);
        }
    }

    @Override
    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        BufferType type = (BufferType)((Object)EnderIO.blockBuffer.func_176203_a(stack.func_77960_j()).func_177229_b(BufferType.TYPE));
        if (stack.field_77994_a == 1 && type.hasPower && !type.isCreative) {
            int energy = this.getEnergyStored(stack);
            int maxInput = Config.powerConduitTierThreeRF / 20;
            int energyReceived = Math.min(CapacitorKey.BUFFER_POWER_BUFFER.get(DefaultCapacitorData.BASIC_CAPACITOR) - energy, Math.min(maxReceive, maxInput));
            if (!simulate) {
                PowerHandlerUtil.setStoredEnergyForItem(stack, energy += energyReceived);
            }
            return energyReceived;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ItemStack stack, int maxExtract, boolean simulate) {
        BufferType type = (BufferType)((Object)EnderIO.blockBuffer.func_176203_a(stack.func_77960_j()).func_177229_b(BufferType.TYPE));
        if (stack.field_77994_a == 1 && type.hasPower) {
            int energy = PowerHandlerUtil.getStoredEnergyForItem(stack);
            int energyExtracted = Math.min(energy, Math.min(Config.powerConduitTierThreeRF / 20, maxExtract));
            if (!simulate && !type.isCreative) {
                PowerHandlerUtil.setStoredEnergyForItem(stack, energy -= energyExtracted);
            }
            return energyExtracted;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ItemStack stack) {
        BufferType type = (BufferType)((Object)EnderIO.blockBuffer.func_176203_a(stack.func_77960_j()).func_177229_b(BufferType.TYPE));
        if (stack.field_77994_a == 1 && type.hasPower) {
            return type.isCreative ? CapacitorKey.BUFFER_POWER_BUFFER.get(DefaultCapacitorData.BASIC_CAPACITOR) : PowerHandlerUtil.getStoredEnergyForItem(stack);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ItemStack stack) {
        if (stack.field_77994_a == 1 && ((BufferType)((Object)EnderIO.blockBuffer.func_176203_a((int)stack.func_77960_j()).func_177229_b(BufferType.TYPE))).hasPower) {
            return CapacitorKey.BUFFER_POWER_BUFFER.get(DefaultCapacitorData.BASIC_CAPACITOR);
        }
        return 0;
    }

    public boolean func_77636_d(ItemStack stack) {
        return ((BufferType)((Object)EnderIO.blockBuffer.func_176203_a((int)stack.func_77960_j()).func_177229_b(BufferType.TYPE))).isCreative || super.func_77636_d(stack);
    }
}

