/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.InventoryWrapper;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.Util;
import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import crazypants.enderio.capacitor.CapacitorHelper;
import crazypants.enderio.capacitor.ICapacitorData;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IMachine;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.MachineSound;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.YetaUtil;
import crazypants.util.ResettingFlag;
import info.loenwind.autosave.Reader;
import info.loenwind.autosave.Writer;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.handlers.enderio.HandleIOMode;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public abstract class AbstractMachineEntity
extends TileEntityEio
implements ISidedInventory,
IMachine,
IRedstoneModeControlable,
IRedstoneConnectable,
IIoConfigurable {
    @Store(value={Store.StoreFor.CLIENT, Store.StoreFor.SAVE})
    @Nonnull
    public EnumFacing facing = EnumFacing.SOUTH;
    protected int ticksSinceSync = -1;
    @Store(value={Store.StoreFor.CLIENT, Store.StoreFor.SAVE})
    protected ResettingFlag forceClientUpdate = new ResettingFlag();
    protected boolean lastActive;
    protected int ticksSinceActiveChanged = 0;
    @Store
    protected ItemStack[] inventory;
    protected final SlotDefinition slotDefinition;
    @Store
    protected RedstoneControlMode redstoneControlMode;
    @Store(value={Store.StoreFor.CLIENT, Store.StoreFor.SAVE})
    protected boolean redstoneCheckPassed;
    private boolean redstoneStateDirty = true;
    @Store(handler=HandleIOMode.class)
    protected Map<EnumFacing, IoMode> faceModes;
    @Nonnull
    private final int[] allSlots;
    protected boolean notifyNeighbours = false;
    @SideOnly(value=Side.CLIENT)
    private MachineSound sound;
    private final ResourceLocation soundRes;
    @Store
    private IBlockState paintSource = null;

    public static ResourceLocation getSoundFor(String sound) {
        return sound == null ? null : new ResourceLocation(EnderIO.DOMAIN + ":" + sound);
    }

    public AbstractMachineEntity(SlotDefinition slotDefinition) {
        this.slotDefinition = slotDefinition;
        this.inventory = new ItemStack[slotDefinition.getNumSlots()];
        this.redstoneControlMode = RedstoneControlMode.IGNORE;
        this.soundRes = AbstractMachineEntity.getSoundFor(this.getSoundName());
        this.allSlots = new int[slotDefinition.getNumSlots()];
        for (int i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
    }

    @Override
    @Nonnull
    public IoMode toggleIoModeForFace(@Nullable EnumFacing faceHit) {
        IoMode curMode = this.getIoMode(faceHit);
        IoMode mode = curMode.next();
        while (!this.supportsMode(faceHit, mode)) {
            mode = mode.next();
        }
        this.setIoMode(faceHit, mode);
        return mode != null ? mode : IoMode.NONE;
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        return true;
    }

    @Override
    public void setIoMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        if (mode == IoMode.NONE && this.faceModes == null) {
            return;
        }
        if (this.faceModes == null) {
            this.faceModes = new EnumMap<EnumFacing, IoMode>(EnumFacing.class);
        }
        this.faceModes.put(faceHit, mode);
        this.forceClientUpdate.set();
        this.notifyNeighbours = true;
        this.updateBlock();
    }

    @Override
    public void clearAllIoModes() {
        if (this.faceModes != null) {
            this.faceModes = null;
            this.forceClientUpdate.set();
            this.notifyNeighbours = true;
            this.updateBlock();
        }
    }

    @Override
    @Nonnull
    public IoMode getIoMode(@Nullable EnumFacing face) {
        if (this.faceModes == null) {
            return IoMode.NONE;
        }
        IoMode res = this.faceModes.get(face);
        if (res == null) {
            return IoMode.NONE;
        }
        return res;
    }

    public SlotDefinition getSlotDefinition() {
        return this.slotDefinition;
    }

    public boolean isValidUpgrade(@Nonnull ItemStack itemstack) {
        for (int i = this.slotDefinition.getMinUpgradeSlot(); i <= this.slotDefinition.getMaxUpgradeSlot(); ++i) {
            if (!this.func_94041_b(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidInput(@Nonnull ItemStack itemstack) {
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
            if (!this.func_94041_b(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidOutput(@Nonnull ItemStack itemstack) {
        for (int i = this.slotDefinition.getMinOutputSlot(); i <= this.slotDefinition.getMaxOutputSlot(); ++i) {
            if (!this.func_94041_b(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public final boolean func_94041_b(int i, ItemStack itemstack) {
        if (itemstack == null || itemstack.func_77973_b() == null) {
            return false;
        }
        if (this.slotDefinition.isUpgradeSlot(i)) {
            ICapacitorData capacitorData = CapacitorHelper.getCapacitorDataFromItemStack(itemstack);
            return itemstack.func_77973_b() == EnderIO.itemBasicCapacitor && itemstack.func_77952_i() > 0 || capacitorData != null;
        }
        return this.isMachineItemValidForSlot(i, itemstack);
    }

    protected abstract boolean isMachineItemValidForSlot(int var1, ItemStack var2);

    @Override
    public RedstoneControlMode getRedstoneControlMode() {
        return this.redstoneControlMode;
    }

    @Override
    public void setRedstoneControlMode(RedstoneControlMode redstoneControlMode) {
        this.redstoneControlMode = redstoneControlMode;
        this.redstoneStateDirty = true;
        this.updateBlock();
    }

    @Nonnull
    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing == null ? EnumFacing.SOUTH : facing;
        this.func_70296_d();
    }

    public abstract boolean isActive();

    public String getSoundName() {
        return null;
    }

    public boolean hasSound() {
        return this.getSoundName() != null;
    }

    public float getVolume() {
        return Config.machineSoundVolume;
    }

    public float getPitch() {
        return 1.0f;
    }

    protected boolean shouldPlaySound() {
        return this.isActive() && !this.func_145837_r();
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSound() {
        if (Config.machineSoundsEnabled && this.hasSound()) {
            if (this.shouldPlaySound()) {
                if (this.sound == null) {
                    this.sound = new MachineSound(this.soundRes, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, this.getVolume(), this.getPitch());
                    FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
                }
            } else if (this.sound != null) {
                this.sound.endPlaying();
                this.sound = null;
            }
        }
    }

    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            this.updateEntityClient();
            return;
        }
        boolean requiresClientSync = this.forceClientUpdate.peek();
        boolean prevRedCheck = this.redstoneCheckPassed;
        if (this.redstoneStateDirty) {
            this.redstoneCheckPassed = RedstoneControlMode.isConditionMet(this.redstoneControlMode, (TileEntity)this);
            this.redstoneStateDirty = false;
        }
        if (this.shouldDoWorkThisTick(5)) {
            requiresClientSync |= this.doSideIo();
        }
        requiresClientSync |= prevRedCheck != this.redstoneCheckPassed;
        if (requiresClientSync |= this.processTasks(this.redstoneCheckPassed)) {
            IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, bs, bs, 3);
            this.func_70296_d();
        }
        if (this.notifyNeighbours) {
            this.field_145850_b.func_180496_d(this.field_174879_c, this.func_145838_q());
            this.notifyNeighbours = false;
        }
    }

    protected void updateEntityClient() {
        if (this.isActive() != this.lastActive) {
            ++this.ticksSinceActiveChanged;
            if (this.ticksSinceActiveChanged > 20 || this.isActive()) {
                this.ticksSinceActiveChanged = 0;
                this.lastActive = this.isActive();
                this.forceClientUpdate.set();
            }
        }
        if (this.hasSound()) {
            this.updateSound();
        }
        if (this.forceClientUpdate.read()) {
            IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, bs, bs, 3);
        } else {
            YetaUtil.refresh((TileEntity)this);
        }
    }

    protected boolean doSideIo() {
        if (this.faceModes == null) {
            return false;
        }
        boolean res = false;
        Set<Map.Entry<EnumFacing, IoMode>> ents = this.faceModes.entrySet();
        for (Map.Entry<EnumFacing, IoMode> ent : ents) {
            IoMode mode = ent.getValue();
            if (mode.pulls()) {
                res |= this.doPull(ent.getKey());
            }
            if (!mode.pushes()) continue;
            res |= this.doPush(ent.getKey());
        }
        return res;
    }

    protected boolean doPush(@Nullable EnumFacing dir) {
        if (dir == null || this.slotDefinition.getNumOutputSlots() <= 0 || !this.shouldDoWorkThisTick(20)) {
            return false;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
        return this.doPush(dir, te, this.slotDefinition.minOutputSlot, this.slotDefinition.maxOutputSlot);
    }

    protected boolean doPush(EnumFacing dir, TileEntity te, int minSlot, int maxSlot) {
        if (te == null) {
            return false;
        }
        for (int i = minSlot; i <= maxSlot; ++i) {
            int num;
            ItemStack item = this.inventory[i];
            if (item == null || (num = ItemUtil.doInsertItem((Object)te, (ItemStack)item, (EnumFacing)dir.func_176734_d())) <= 0) continue;
            item.field_77994_a -= num;
            if (item.field_77994_a <= 0) {
                item = null;
            }
            this.inventory[i] = item;
            this.func_70296_d();
        }
        return false;
    }

    protected boolean doPull(@Nullable EnumFacing dir) {
        if (dir == null || this.slotDefinition.getNumInputSlots() <= 0 || !this.shouldDoWorkThisTick(20)) {
            return false;
        }
        boolean hasSpace = false;
        for (int slot = this.slotDefinition.minInputSlot; slot <= this.slotDefinition.maxInputSlot && !hasSpace; ++slot) {
            hasSpace = this.inventory[slot] == null ? true : this.inventory[slot].field_77994_a < Math.min(this.inventory[slot].func_77976_d(), this.getInventoryStackLimit(slot));
        }
        if (!hasSpace) {
            return false;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
        if (te == null) {
            return false;
        }
        if (!(te instanceof IInventory)) {
            return false;
        }
        Object target = te instanceof ISidedInventory ? (ISidedInventory)te : new InventoryWrapper((IInventory)te);
        int[] targetSlots = target.func_180463_a(dir.func_176734_d());
        if (targetSlots == null) {
            return false;
        }
        for (int inputSlot = this.slotDefinition.minInputSlot; inputSlot <= this.slotDefinition.maxInputSlot; ++inputSlot) {
            if (!this.doPull(inputSlot, (ISidedInventory)target, targetSlots, dir)) continue;
            return false;
        }
        return false;
    }

    protected boolean doPull(int inputSlot, ISidedInventory target, int[] targetSlots, EnumFacing side) {
        for (int i = 0; i < targetSlots.length; ++i) {
            int res;
            int tSlot = targetSlots[i];
            ItemStack targetStack = target.func_70301_a(tSlot);
            if (targetStack == null || !target.func_180461_b(i, targetStack, side.func_176734_d()) || (res = ItemUtil.doInsertItem((Object)this, (ItemStack)targetStack, (EnumFacing)side)) <= 0) continue;
            targetStack = targetStack.func_77946_l();
            targetStack.field_77994_a -= res;
            if (targetStack.field_77994_a <= 0) {
                targetStack = null;
            }
            target.func_70299_a(tSlot, targetStack);
            return true;
        }
        return false;
    }

    protected abstract boolean processTasks(boolean var1);

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.readCommon(nbtRoot);
    }

    public void readCommon(NBTTagCompound nbtRoot) {
    }

    public void readFromItemStack(ItemStack stack) {
        if (stack == null) {
            return;
        }
        NBTTagCompound root = stack.func_77978_p();
        if (root == null) {
            return;
        }
        Reader.read(Store.StoreFor.ITEM, root, this);
        if (root.func_74764_b("eio.abstractMachine")) {
            try {
                this.doingOtherNbt = true;
                this.readCommon(root);
            }
            finally {
                this.doingOtherNbt = false;
            }
        }
        if (this instanceof IPaintable.IPaintableTileEntity) {
            this.paintSource = PainterUtil2.readNbt(root);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        this.writeCommon(nbtRoot);
    }

    public void writeCommon(NBTTagCompound nbtRoot) {
    }

    public void writeToItemStack(ItemStack stack) {
        if (stack == null) {
            return;
        }
        NBTTagCompound root = stack.func_77978_p();
        if (root == null) {
            root = new NBTTagCompound();
            stack.func_77982_d(root);
        }
        root.func_74757_a("eio.abstractMachine", true);
        try {
            this.doingOtherNbt = true;
            this.writeCommon(root);
        }
        finally {
            this.doingOtherNbt = false;
        }
        Writer.write(Store.StoreFor.ITEM, root, this);
        if (this instanceof IPaintable.IPaintableTileEntity) {
            PainterUtil2.writeNbt(root, this.paintSource);
        }
        String name = stack.func_82837_s() ? stack.func_82833_r() : EnderIO.lang.localizeExact(stack.func_77977_a() + ".name");
        name = name + " " + EnderIO.lang.localize("machine.tooltip.configured");
        stack.func_151001_c(name);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public int func_70302_i_() {
        return this.slotDefinition.getNumSlots();
    }

    public int getInventoryStackLimit(int slot) {
        return this.func_70297_j_();
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return Util.decrStackSize((IInventory)this, (int)slot, (int)amount);
    }

    public void func_70299_a(int slot, @Nullable ItemStack contents) {
        this.inventory[slot] = contents == null ? contents : contents.func_77946_l();
        if (contents != null && contents.field_77994_a > this.getInventoryStackLimit(slot)) {
            contents.field_77994_a = this.getInventoryStackLimit(slot);
        }
        this.func_70296_d();
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
        this.func_70296_d();
    }

    public ItemStack func_70304_b(int index) {
        ItemStack res = this.inventory[index];
        this.inventory[index] = null;
        this.func_70296_d();
        return res;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    @Nonnull
    public String func_70005_c_() {
        return this.getMachineName();
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Nonnull
    public int[] func_180463_a(EnumFacing var1) {
        if (this.isSideDisabled(var1)) {
            return new int[0];
        }
        return this.allSlots;
    }

    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing side) {
        if (this.isSideDisabled(side) || !this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        ItemStack existing = this.inventory[slot];
        if (existing != null) {
            return existing.func_77985_e() && existing.func_77969_a(itemstack);
        }
        return this.isMachineItemValidForSlot(slot, itemstack);
    }

    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing side) {
        if (this.isSideDisabled(side)) {
            return false;
        }
        if (!this.slotDefinition.isOutputSlot(slot)) {
            return false;
        }
        return this.canExtractItem(slot, itemstack);
    }

    protected boolean canExtractItem(int slot, ItemStack itemstack) {
        if (this.inventory[slot] == null || this.inventory[slot].field_77994_a < itemstack.field_77994_a) {
            return false;
        }
        return itemstack.func_77973_b() == this.inventory[slot].func_77973_b();
    }

    public boolean isSideDisabled(EnumFacing dir) {
        return this.getIoMode(dir) == IoMode.DISABLED;
    }

    public void onNeighborBlockChange(Block blockId) {
        this.redstoneStateDirty = true;
    }

    @Override
    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, EnumFacing from) {
        return true;
    }

    @Override
    public BlockCoord getLocation() {
        return new BlockCoord(this.field_174879_c);
    }

    @Override
    public boolean getRedstoneControlStatus() {
        return this.redstoneCheckPassed;
    }

    public void setPaintSource(@Nullable IBlockState paintSource) {
        this.paintSource = paintSource;
        this.func_70296_d();
        this.updateBlock();
    }

    public IBlockState getPaintSource() {
        return this.paintSource;
    }
}

