/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.skull;

import crazypants.enderio.BlockEio;
import crazypants.enderio.IHaveRenderers;
import crazypants.enderio.ModObject;
import crazypants.enderio.item.skull.ItemEndermanSkull;
import crazypants.enderio.item.skull.TileEndermanSkull;
import crazypants.util.ClientUtil;
import crazypants.util.NullHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="thaumcraft.api.crafting.IInfusionStabiliser", modid="Thaumcraft")
public class BlockEndermanSkull
extends BlockEio<TileEndermanSkull>
implements IHaveRenderers {
    @Nonnull
    public static final PropertyEnum<SkullType> VARIANT = NullHelper.notnullM(PropertyEnum.func_177709_a((String)"variant", SkullType.class), "PropertyEnum.create()");
    @Nonnull
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);

    public static BlockEndermanSkull create() {
        BlockEndermanSkull res = new BlockEndermanSkull();
        res.init();
        return res;
    }

    private BlockEndermanSkull() {
        super(ModObject.blockEndermanSkull.getUnlocalisedName(), TileEndermanSkull.class, NullHelper.notnullM(Material.field_151594_q, "Material.CIRCUITS"));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    protected ItemBlock createItemBlock() {
        return new ItemEndermanSkull((Block)this, this.name);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        Item item = Item.func_150898_a((Block)this);
        int num = SkullType.values().length;
        for (int i = 0; i < num; ++i) {
            SkullType st = SkullType.values()[i];
            ClientUtil.regRenderer(item, i, ModObject.blockEndermanSkull.getUnlocalisedName() + "_" + st.name);
        }
    }

    public int func_180651_a(IBlockState state) {
        SkullType var = (SkullType)((Object)state.func_177229_b(VARIANT));
        return var.ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        SkullType var = SkullType.getTypeFromMeta(meta);
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)var));
    }

    public int func_176201_c(IBlockState state) {
        SkullType var = (SkullType)((Object)state.func_177229_b(VARIANT));
        return var.ordinal();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState bs) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        if (world != null && pos != null) {
            if (player != null) {
                int inc = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
                float facingYaw = -22.5f * (float)inc;
                TileEndermanSkull te = (TileEndermanSkull)this.getTileEntity((IBlockAccess)world, pos);
                if (te != null) {
                    te.setYaw(facingYaw);
                }
            }
            if (world.field_72995_K) {
                return;
            }
            if (stack != null) {
                world.func_175656_a(pos, this.func_176203_a(stack.func_77952_i()));
                world.func_184138_a(pos, state, state, 3);
            }
        }
    }

    @Deprecated
    public AxisAlignedBB func_180640_a(IBlockState bs, World worldIn, BlockPos pos) {
        TileEndermanSkull tileEntity;
        if (worldIn != null && pos != null && (tileEntity = (TileEndermanSkull)this.getTileEntity((IBlockAccess)worldIn, pos)) != null) {
            tileEntity.lookingAt = 20;
        }
        return super.func_180640_a(bs, worldIn, pos);
    }

    public static enum SkullType implements IStringSerializable
    {
        BASE("base", false),
        REANIMATED("reanimated", true),
        TORMENTED("tormented", false),
        REANIMATED_TORMENTED("reanimatedTormented", true);

        @Nonnull
        final String name;
        final boolean showEyes;

        private SkullType(String name, boolean showEyes) {
            this.name = name;
            this.showEyes = showEyes;
        }

        @Nonnull
        public String func_176610_l() {
            return NullHelper.notnullJ(this.name.toLowerCase(Locale.ENGLISH), "String.toLowerCase()");
        }

        @Nonnull
        public static SkullType getTypeFromMeta(int meta) {
            return NullHelper.notnullJ(SkullType.values()[meta >= 0 && meta < SkullType.values().length ? meta : 0], "Enum.values()");
        }
    }
}

